/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class LoadESPForecastReport
extends LoadReport {
    private String folder = null;
    private String sESPReportRec;
    final String inputPattern5 = "1ESP VER";
    final String inputPattern6 = "0                           ";
    final String inputPattern1 = "JOBNAME     SUBMISSION  SAM-";
    final String inputPattern3 = "TIME   DATE  PLES";
    final String inputPattern4 = "USED  (MINS)";
    final String inputPattern2 = "TOTALS:";
    final String inputPattern7 = "  LongName =";
    private int endHh;
    private int endMm;
    final int readAheadLimit = 3000;

    public LoadESPForecastReport(LegacyReportInputStreamSuplier legacyForecastReport, ExternalParameters externalParameters) {
        super(legacyForecastReport, externalParameters);
    }

    @Override
    protected CommonJobFH nextJobInternal() throws FileNotFoundException, IOException, ParseException {
        while ((this.sESPReportRec = this.br.readLine()) != null) {
            String longNameLine;
            if (this.sESPReportRec.contains("JOBNAME     SUBMISSION  SAM-")) {
                this.reportStarted = true;
            }
            if (this.reportStarted & this.sESPReportRec.contains("TOTALS:")) {
                return null;
            }
            if (this.isLineToBeSkipped(this.sESPReportRec) || !this.reportStarted || !this.dateHandled && this.sESPReportRec.contains("  LongName =")) continue;
            String jobNameFromReport = this.sESPReportRec.substring(1, 9).trim();
            this.br.mark(3000);
            while (this.isLineToBeSkipped(longNameLine = this.br.readLine())) {
            }
            if (longNameLine.startsWith("  LongName =")) {
                jobNameFromReport = longNameLine.substring("  LongName =".length()).trim();
            } else {
                this.br.reset();
            }
            SimpleDateFormat currYear = new SimpleDateFormat("yyyy");
            String repDate = this.sESPReportRec.substring(18, 23);
            String repYearDate = this.dateFormatter.dateFormatyyyyMMdd.format(this.dateFormatter.dateFormatyyyyddMMM.parse(currYear.format(this.date) + repDate.replaceAll("\\s", "0")));
            if (!this.willJobRunInDateWithNewDay(repYearDate, this.sESPReportRec.substring(12, 14) + this.sESPReportRec.substring(15, 17))) continue;
            this.endHh = Integer.valueOf(this.sESPReportRec.substring(12, 14)) + Integer.valueOf(this.sESPReportRec.substring(35, 39).replaceAll("\\s", "0")) / 60;
            this.endMm = Integer.valueOf(this.sESPReportRec.substring(15, 17)) + Integer.valueOf(this.sESPReportRec.substring(35, 39).replaceAll("\\s", "0")) % 60;
            this.folder = this.sESPReportRec.substring(82, 90).trim();
            CommonJobFH job = new CommonJobFH(jobNameFromReport, "", "", this.folder, "", "", this.sESPReportRec.substring(12, 14) + ":" + this.sESPReportRec.substring(15, 17) + ":00", String.format("%02d", this.endHh) + ":" + String.format("%02d", this.endMm) + ":" + String.format("%02d", Integer.valueOf(this.sESPReportRec.substring(40, 41)) * 6), this.runDate, this.date.toString(), (String)(!this.sESPReportRec.substring(100, 101).equals(" ") ? jobNameFromReport + "." + this.sESPReportRec.substring(100, 108) : jobNameFromReport), "CA-ESP", "", "");
            return job;
        }
        return null;
    }

    public boolean isLineToBeSkipped(String line) {
        return line.startsWith("1ESP VER") | line.startsWith("0                           ") | line.contains("JOBNAME     SUBMISSION  SAM-") | line.contains("TIME   DATE  PLES") | line.contains("USED  (MINS)") | line.length() < 23;
    }
}

