/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import com.bmc.cnvvalidation.MappingFileHandler;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Objects;

public class LoadAutosysForecastReport
extends LoadReport {
    private String prevJob = null;
    private final String[] currPrevFolder;
    private String prevTime = null;
    private String folTime = null;
    private String prevDate = null;
    private String folDate = null;
    private Boolean lastProcessed = false;
    private Boolean correctReport = false;
    private Boolean levelShiftCalculated = false;
    private Integer currentLevel = 0;
    private Integer prevLevel = null;
    private Integer levelShift = null;
    MappingFileHandler mappingFileHandler = null;
    CommonJobFH job = null;

    public LoadAutosysForecastReport(LegacyReportInputStreamSuplier legacyForecastReport, ExternalParameters externalParameters) {
        super(legacyForecastReport, externalParameters);
        try {
            this.mappingFileHandler = new MappingFileHandler(externalParameters.getJobnameMappingFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.currPrevFolder = new String[20];
    }

    @Override
    protected CommonJobFH nextJobInternal() throws IOException, ParseException {
        String sAutosysReportRec;
        this.job = null;
        while ((sAutosysReportRec = this.br.readLine()) != null) {
            if (sAutosysReportRec.contains("Job Forecast Report")) {
                this.correctReport = true;
            }
            if (sAutosysReportRec.equals("") | sAutosysReportRec.contains("Job Forecast Report") | sAutosysReportRec.contains("From: ") & sAutosysReportRec.contains("To: ") | sAutosysReportRec.contains("Job Name") & sAutosysReportRec.contains("Next Start") & sAutosysReportRec.contains("Atomic Start Conditions") | sAutosysReportRec.contains("_________________")) continue;
            if (!this.correctReport.booleanValue()) break;
            String[] listOfFields = sAutosysReportRec.split("\\s+");
            if (listOfFields.length < 3) continue;
            if (!this.levelShiftCalculated.booleanValue()) {
                if (sAutosysReportRec.startsWith(" ")) {
                    this.levelShift = sAutosysReportRec.indexOf(sAutosysReportRec.trim());
                    this.currentLevel = sAutosysReportRec.indexOf(sAutosysReportRec.trim()) / this.levelShift;
                    this.levelShiftCalculated = true;
                }
            } else {
                this.currentLevel = sAutosysReportRec.indexOf(sAutosysReportRec.trim()) / this.levelShift;
            }
            if (this.prevJob == null) {
                this.prevJob = listOfFields[0];
                this.currPrevFolder[0] = "General";
                this.folTime = this.prevTime = this.isValidTime(listOfFields[2]) ? listOfFields[2] : "00:00:00";
                this.folDate = this.prevDate = this.isValidTime(listOfFields[2]) ? listOfFields[1] : "noDate";
                this.prevLevel = this.currentLevel;
                continue;
            }
            if (this.currentLevel != 0) {
                if (this.prevLevel < this.currentLevel) {
                    this.currPrevFolder[this.currentLevel.intValue()] = this.currentLevel == 1 ? this.prevJob : this.currPrevFolder[this.currentLevel - 1] + "/" + this.prevJob;
                    this.prevJob = listOfFields[1];
                    this.prevTime = this.isValidTime(listOfFields[3]) ? listOfFields[3] : this.folTime;
                    this.prevDate = this.isValidTime(listOfFields[3]) ? listOfFields[2] : this.folDate;
                    this.prevLevel = this.currentLevel;
                    continue;
                }
                if (!Objects.equals(this.prevDate, "noDate") && this.willJobRunInDateWithNewDay(this.dateFormatter.dateFormatyyyyMMdd.format(this.dateFormatter.dateFormatMMddyyyy.parse(this.prevDate)), this.prevTime.substring(0, 2) + this.prevTime.substring(3, 5))) {
                    this.newJob();
                }
                this.prevJob = listOfFields[1];
                this.prevTime = this.isValidTime(listOfFields[3]) ? listOfFields[3] : this.folTime;
                this.prevDate = this.isValidTime(listOfFields[3]) ? listOfFields[2] : this.folDate;
                this.prevLevel = this.currentLevel;
            } else {
                if (!Objects.equals(this.prevDate, "noDate") && this.willJobRunInDateWithNewDay(this.dateFormatter.dateFormatyyyyMMdd.format(this.dateFormatter.dateFormatMMddyyyy.parse(this.prevDate)), this.prevTime.substring(0, 2) + this.prevTime.substring(3, 5))) {
                    this.newJob();
                }
                this.prevJob = listOfFields[0];
                this.folTime = this.prevTime = this.isValidTime(listOfFields[2]) ? listOfFields[2] : "00:00:00";
                this.folDate = this.prevDate = this.isValidTime(listOfFields[2]) ? listOfFields[1] : "noDate";
                this.prevLevel = this.currentLevel;
            }
            if (this.job == null) continue;
            return this.job;
        }
        if (this.correctReport & this.lastProcessed == false) {
            this.lastProcessed = true;
            if (!Objects.equals(this.prevDate, "noDate") && this.willJobRunInDateWithNewDay(this.dateFormatter.dateFormatyyyyMMdd.format(this.dateFormatter.dateFormatMMddyyyy.parse(this.prevDate)), this.prevTime.substring(0, 2) + this.prevTime.substring(3, 5))) {
                this.newJob();
                if (this.job != null) {
                    return this.job;
                }
            }
        }
        this.prevJob = null;
        this.lastProcessed = false;
        return null;
    }

    private void newJob() throws ParseException {
        this.job = new CommonJobFH(this.mappingFileHandler.getMapValue(this.prevJob), "", "", this.currPrevFolder[this.prevLevel], "", "", (String)(this.prevTime.length() == 8 ? this.prevTime : this.prevTime + ":00"), "", this.dateFormatter.dateFormatyyyyMMdd.format(this.dateFormatter.dateFormatMMddyyyy.parse(this.prevDate)), this.date.toString(), "", "CA-Autosys", "", "");
    }

    public boolean isValidTime(String timeString) {
        SimpleDateFormat HHmmss = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat HHmm = new SimpleDateFormat("HH:mm");
        try {
            if (timeString.length() == 8) {
                HHmmss.parse(timeString);
            } else {
                HHmm.parse(timeString);
            }
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

