/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import com.bmc.cnvvalidation.MappingFileHandler;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoadAutosysExecutionReport
extends LoadReport {
    private final MappingFileHandler mappingFileHandler;
    private final SimpleDateFormat autosysDateFormatter = new SimpleDateFormat("MM/dd/yyyy");

    public LoadAutosysExecutionReport(LegacyReportInputStreamSuplier forecastReport, ExternalParameters externalParameters) throws IOException {
        super(forecastReport, externalParameters);
        this.mappingFileHandler = new MappingFileHandler(externalParameters.getJobnameMappingFile());
    }

    @Override
    protected CommonJobFH nextJobInternal() throws IOException, ParseException {
        String line;
        while ((line = this.br.readLine()) != null) {
            Line parsedLine = Line.parse(line);
            if (parsedLine.isEmpty()) continue;
            return new CommonJobFH(this.mappingFileHandler.getMapValue(parsedLine.jobName), "", "", "", "", "1", parsedLine.time, "", this.formatDate(parsedLine.date), this.date.toString(), parsedLine.jobName, "CA-Autosys", "", "");
        }
        return null;
    }

    private String formatDate(String originalDate) throws ParseException {
        Date formattedDate = this.autosysDateFormatter.parse(originalDate);
        return this.dateFormatter.dateFormatyyyyMMdd.format(formattedDate);
    }

    private static class Line {
        private static final Line EMPTY_LINE = new Line("", "", "");
        private static final Pattern START_JOB_PATTERN = Pattern.compile("\\[(?<date>\\d{2}/\\d{2}/\\d{4})\\s+(?<time>\\d{2}:\\d{2}:\\d{2})]\\s+.*EVENT:\\s+STARTJOB\\s+JOB: *(?<jobName>.*)$");
        private final String date;
        private final String time;
        private final String jobName;

        public boolean isEmpty() {
            return this == EMPTY_LINE;
        }

        private Line(String jobName, String date, String time) {
            this.jobName = jobName;
            this.date = date;
            this.time = time;
        }

        public static Line parse(String rawLine) {
            Matcher matcher = START_JOB_PATTERN.matcher(rawLine);
            if (matcher.matches()) {
                String date = matcher.group("date");
                String jobName = matcher.group("jobName");
                String time = matcher.group("time");
                return new Line(jobName, date, time);
            }
            return EMPTY_LINE;
        }
    }
}

