/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadAutosysForecastReport;
import com.bmc.cnvvalidation.LoadAutosysForecastReportFormat2;
import com.bmc.cnvvalidation.LoadAutosysForecastReportFormat3;
import com.bmc.cnvvalidation.LoadReport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class AutosysForecastReportFactory {
    private LegacyReportInputStreamSuplier legacyForecastReport;
    private ExternalParameters externalParameters;
    private boolean correctReport = false;
    private int reportFormatLevel = 0;

    public AutosysForecastReportFactory(LegacyReportInputStreamSuplier legacyForecastReport, ExternalParameters externalParameters) {
        this.legacyForecastReport = legacyForecastReport;
        this.externalParameters = externalParameters;
    }

    public LoadReport getLoader() {
        LoadReport loadAutosysForecastReport = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.legacyForecastReport.get()));
        try {
            String sAutosysReportRec;
            while ((sAutosysReportRec = br.readLine()) != null) {
                this.determineReportFormatLevel(sAutosysReportRec);
                if (!this.correctReport) continue;
                switch (this.reportFormatLevel) {
                    case 1: {
                        loadAutosysForecastReport = new LoadAutosysForecastReport(this.legacyForecastReport, this.externalParameters);
                        break;
                    }
                    case 2: {
                        loadAutosysForecastReport = new LoadAutosysForecastReportFormat2(this.legacyForecastReport, this.externalParameters);
                        break;
                    }
                    case 3: {
                        loadAutosysForecastReport = new LoadAutosysForecastReportFormat3(this.legacyForecastReport, this.externalParameters);
                        break;
                    }
                }
                return loadAutosysForecastReport;
            }
        }
        catch (IOException e) {
            return null;
        }
        return loadAutosysForecastReport;
    }

    private void determineReportFormatLevel(String sAutosysReportRec) {
        if (sAutosysReportRec.contains("Job Forecast Report")) {
            this.correctReport = true;
            this.reportFormatLevel = 1;
        }
        if (sAutosysReportRec.contains("AutoSys Workload Automation Forecast Report")) {
            this.correctReport = true;
            this.reportFormatLevel = 3;
        }
        if (sAutosysReportRec.contains("Server,Box,Job,Machine,Start Time,End Time, Duration")) {
            this.correctReport = true;
            this.reportFormatLevel = 2;
        }
    }
}

