/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.workspace.entities;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.workspace.AbstractOrderableEntity;
import com.bmc.ctmconvert.workspace.DoCond;
import com.bmc.ctmconvert.workspace.DoCondImp;
import com.bmc.ctmconvert.workspace.IOnStatement;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.InCondition;
import com.bmc.ctmconvert.workspace.entities.OnDo;
import com.bmc.ctmconvert.workspace.entities.OnStatement;
import com.bmc.ctmconvert.workspace.entities.OutCondition;
import com.bmc.ctmconvert.workspace.entities.XmlEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BaseXmlEntity
extends AbstractOrderableEntity
implements XmlEntity {
    private static final String INCOND = "INCOND";
    private List<XmlElement> subXmlElementsList = new ArrayList<XmlElement>();
    private Map<String, String> attributes;
    private List<NewMessage> messages;
    private String name;
    private String tag;
    private WorkspaceId id;

    public BaseXmlEntity(WorkspaceId id, String name, String tag) {
        super(id);
        this.name = name;
        this.tag = tag;
        this.id = id;
        this.attributes = new HashMap<String, String>();
        this.messages = new ArrayList<NewMessage>();
    }

    public BaseXmlEntity(String name) {
        this(new WorkspaceId(), name, "");
    }

    @Override
    public void addElement(XmlElement xmlElement) {
        this.subXmlElementsList.add(xmlElement);
    }

    public void addAllElements(List<XmlElement> xmlElements) {
        this.subXmlElementsList.addAll(xmlElements);
    }

    public void removeElement(XmlElement xmlElement) {
        this.subXmlElementsList.remove(xmlElement);
    }

    @Override
    public String toXmlListElements() {
        StringBuilder xmlString = new StringBuilder();
        for (XmlElement subElement : this.subXmlElementsList) {
            String subelementStr = subElement.toString();
            subelementStr = subelementStr.replace('?', ' ');
            xmlString.append(subelementStr.toString().replaceAll("< xml version=\"1.0\" encoding=\"UTF-8\" >", ""));
        }
        return xmlString.toString();
    }

    @Override
    public List<XmlElement> getSubElements() {
        ArrayList<XmlElement> subXmlElementsListCopy = new ArrayList<XmlElement>(this.subXmlElementsList);
        return subXmlElementsListCopy;
    }

    public WorkspaceId getWorkspaceID() {
        return this.id;
    }

    public String toString() {
        return "BaseXmlEntity [name=" + this.name + ", tag=" + this.tag + ", id=" + String.valueOf(this.id) + "]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public Element getXmlDom() {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document document = builder.newDocument();
        Element element = document.createElement(this.tag);
        Map<String, String> attrList = this.getAttributes();
        attrList.forEach((key, value) -> element.setAttribute((String)key, (String)value));
        for (XmlElement subElement : this.subXmlElementsList) {
            Node importedSubElement = document.importNode(subElement.getElement(), true);
            element.appendChild(importedSubElement);
        }
        return element;
    }

    @Override
    public SchedEntity.TYPE getType() {
        return switch (this.tag) {
            case "SMART_FOLDER", "SMART_TABLE" -> SchedEntity.TYPE.SMART_TABLE;
            case "FOLDER", "TABLE" -> SchedEntity.TYPE.TABLE;
            case "SUB_FOLDER", "SUB_TABLE" -> SchedEntity.TYPE.SUB_TABLE;
            case "JOB" -> SchedEntity.TYPE.JOB;
            default -> null;
        };
    }

    public List<XmlElement> getSubElements(String elementTag) {
        ArrayList<XmlElement> subXmlElementsListCopy = new ArrayList<XmlElement>(this.subXmlElementsList);
        ArrayList<XmlElement> retSubXmlElementsList = new ArrayList<XmlElement>();
        for (XmlElement xmlElement : subXmlElementsListCopy) {
            if (!xmlElement.getTagName().equals(elementTag)) continue;
            retSubXmlElementsList.add(xmlElement);
        }
        return retSubXmlElementsList;
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> ret = new HashMap<String, String>(this.attributes);
        return ret;
    }

    @Override
    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public List<NewMessage> getMessages() {
        return new ArrayList<NewMessage>(this.messages);
    }

    @Override
    public void addMessage(NewMessage message) {
        if (!this.messages.contains(message)) {
            this.messages.add(message);
        }
    }

    public boolean changeSubElementName(String elementTag, String elementName, String newName) {
        ArrayList<XmlElement> subXmlElementsListCopy = new ArrayList<XmlElement>(this.subXmlElementsList);
        for (XmlElement xmlElement : subXmlElementsListCopy) {
            DocumentBuilder builder;
            if (!xmlElement.getTagName().equals(elementTag) || !xmlElement.getAttributes().get("NAME").equals(elementName)) continue;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                builder = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            Document doc = builder.newDocument();
            Element elementWithModifiedname = doc.createElement(elementTag);
            Set<Map.Entry<String, String>> attrSet = xmlElement.getAttributes().entrySet();
            for (Map.Entry<String, String> attr : attrSet) {
                String attrValue = attr.getValue();
                String attrName = attr.getKey();
                if (attrName.equals("NAME")) {
                    attrValue = newName;
                }
                elementWithModifiedname.setAttribute(attrName, attrValue);
            }
            this.subXmlElementsList.remove(xmlElement);
            this.subXmlElementsList.add(new XmlElement(elementWithModifiedname));
        }
        return true;
    }

    @Override
    public List<InCondition> getInConditions() {
        ArrayList<InCondition> ret = new ArrayList<InCondition>();
        List<XmlElement> xmlInconds = this.getSubElements(INCOND);
        for (XmlElement condElement : xmlInconds) {
            String condName = condElement.getAttribute("NAME");
            String andStr = condElement.getAttribute("AND_OR");
            String odate = condElement.getAttribute("ODATE");
            InCondition incond = new InCondition(condName, odate, andStr);
            ret.add(incond);
        }
        return ret;
    }

    @Override
    public List<OutCondition> getOutConditions() {
        ArrayList<OutCondition> ret = new ArrayList<OutCondition>();
        List<XmlElement> xmloutconds = this.getSubElements("OUTCOND");
        for (XmlElement condElement : xmloutconds) {
            String condName = condElement.getAttribute("NAME");
            String sign = condElement.getAttribute("SIGN");
            String odate = condElement.getAttribute("ODATE");
            OutCondition outcond = new OutCondition(condName, odate, sign);
            ret.add(outcond);
        }
        return ret;
    }

    @Override
    public List<IOnStatement> getOnDo() {
        ArrayList<IOnStatement> ret = new ArrayList<IOnStatement>();
        List<XmlElement> onElements = this.getSubElements("ON");
        for (XmlElement onElement : onElements) {
            OnStatement onStatement = new OnStatement();
            List<XmlElement> doElements = onElement.getAllDirectchildsElement();
            for (XmlElement doElement : doElements) {
                String action = doElement.getTagName();
                if (action.equals("DOCOND")) {
                    DoCond doCond = this.getDoCond(doElement);
                    onStatement.addDo(doCond);
                    continue;
                }
                OnDo doImp = new OnDo(action);
                this.copyAttribites(doElement, doImp);
                onStatement.addDo(doImp);
            }
            ret.add(onStatement);
        }
        return ret;
    }

    private DoCond getDoCond(XmlElement doElement) {
        String condName = doElement.getAttribute("NAME");
        String sign = doElement.getAttribute("SIGN");
        String odate = doElement.getAttribute("ODATE");
        DoCondImp doCond = new DoCondImp(condName, odate, sign);
        return doCond;
    }

    private void copyAttribites(XmlElement doElement, OnDo doImp) {
        Map<String, String> doAttributes = doElement.getAttributes();
        Consumer<Map.Entry> t = entry -> doImp.addAttribute((String)entry.getKey(), (String)entry.getValue());
        doAttributes.entrySet().stream().forEach(t);
    }

    public Optional<String> getAttribute(String attributeName) {
        if (this.attributes.containsKey(attributeName)) {
            return Optional.of(this.attributes.get(attributeName));
        }
        return Optional.empty();
    }
}

