/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.workspace;

import com.bmc.ctmconvert.common.message.Action;
import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.workspace.AbstractWorkspaceEntity;
import com.bmc.ctmconvert.workspace.IOnStatement;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.OrderableEntity;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.WorkspacePath;
import com.bmc.ctmconvert.workspace.entities.ControlResource;
import com.bmc.ctmconvert.workspace.entities.Folder;
import com.bmc.ctmconvert.workspace.entities.IRBC;
import com.bmc.ctmconvert.workspace.entities.InCondition;
import com.bmc.ctmconvert.workspace.entities.OutCondition;
import com.bmc.ctmconvert.workspace.entities.QuantitativeResource;
import com.bmc.ctmconvert.workspace.entities.Shout;
import com.bmc.ctmconvert.workspace.entities.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractOrderableEntity
extends AbstractWorkspaceEntity
implements OrderableEntity {
    private LinkedHashMap<String, Variable> variablesMap = new LinkedHashMap();
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<NewMessage> messages = new ArrayList<NewMessage>();
    private List<Action> actions = new ArrayList<Action>();
    private List<InCondition> inConditionList = new ArrayList<InCondition>();
    private List<OutCondition> outConditionList = new ArrayList<OutCondition>();
    private List<QuantitativeResource> quantitativeResourceList = new ArrayList<QuantitativeResource>();
    private List<ControlResource> controlResourceList = new ArrayList<ControlResource>();
    private List<IOnStatement> onDoList = new ArrayList<IOnStatement>();
    private List<Shout> shoutList = new ArrayList<Shout>();
    private List<IRBC> rbcList = new ArrayList<IRBC>();
    protected String entityName = "";

    public AbstractOrderableEntity(WorkspaceId id) {
        super(id);
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    @Override
    public void setName(String name) {
        this.entityName = name;
    }

    @Override
    public void addVariable(Variable variable) {
        this.variablesMap.put(variable.getName(), variable);
    }

    @Override
    public void addInCondition(InCondition cond) {
        if (!this.inConditionList.contains(cond)) {
            this.inConditionList.add(cond);
        }
    }

    @Override
    public void addOutCondition(OutCondition cond) {
        if (!this.outConditionList.contains(cond)) {
            this.outConditionList.add(cond);
        }
    }

    @Override
    public void removeOutCondition(String name) {
        List<OutCondition> outCondToRemove = this.outConditionList.stream().filter(item -> Objects.equals(item.getName(), name)).collect(Collectors.toList());
        outCondToRemove.forEach(item -> this.outConditionList.remove(item));
    }

    @Override
    public void removeInCondition(String name) {
        List<InCondition> inCondToRemove = this.inConditionList.stream().filter(item -> Objects.equals(item.getName(), name)).collect(Collectors.toList());
        inCondToRemove.forEach(item -> this.inConditionList.remove(item));
    }

    @Override
    public void addQuantitativeResource(QuantitativeResource res) {
        if (!this.quantitativeResourceList.contains(res)) {
            this.quantitativeResourceList.add(res);
        }
    }

    @Override
    public void addControlResource(ControlResource res) {
        if (!this.controlResourceList.contains(res)) {
            this.controlResourceList.add(res);
        }
    }

    @Override
    public void addOnDo(IOnStatement onStatement) {
        if (!this.onDoList.contains(onStatement)) {
            this.onDoList.add(onStatement);
        }
    }

    @Override
    public void addShout(Shout shout) {
        if (!this.shoutList.contains(shout)) {
            this.shoutList.add(shout);
        }
    }

    @Override
    public void addRBC(IRBC rbc) {
        if (!this.rbcList.contains(rbc)) {
            this.rbcList.add(rbc);
        }
    }

    @Override
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.attributes);
    }

    public void addAttribute(String name, String value) {
        switch (name) {
            case "FOLDER_NAME": {
                name = "TABLE_NAME";
                break;
            }
            case "SUB_APPLICATION": {
                name = "GROUP";
                break;
            }
            case "CREATED_BY": {
                name = "AUTHOR";
                break;
            }
            case "RUN_AS": {
                name = "OWNER";
                break;
            }
            case "OVERRIDE_PATH": {
                name = "OVERLIB";
                break;
            }
            case "RULE_BASED_CALENDAR_RELATIONSHIP": {
                name = "TAG_RELATIONSHIP";
                break;
            }
            case "PARENT_FOLDER": {
                name = "PARENT_TABLE";
                break;
            }
            case "FOLDER_ORDER_METHOD": {
                name = "TABLE_USERDAILY";
                break;
            }
            case "FOLDER_DSN": {
                name = "TABLE_DSN";
                break;
            }
        }
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setDescription(String value) {
        this.attributes.put("DESCRIPTION", value);
    }

    @Override
    public List<Variable> getVariables() {
        return new ArrayList<Variable>(this.variablesMap.values());
    }

    @Override
    public Variable removeVariable(String variableName) {
        return (Variable)this.variablesMap.remove(variableName);
    }

    @Override
    public WorkspacePath getPath() {
        WorkspacePath ret = new WorkspacePath();
        Optional<Folder> parent = this.getParent();
        while (parent.isPresent()) {
            IWorkspaceEntity folder = parent.get();
            if (!(folder instanceof OrderableEntity)) continue;
            OrderableEntity entity = (OrderableEntity)((Object)folder);
            ret.addToHead(entity.getName());
            parent = entity.getParent();
        }
        return ret;
    }

    @Override
    public void setParent(Folder folder) {
        super.setParent(folder);
        Optional<Folder> parent = super.getParent();
        if (folder != null && parent.isPresent() && !parent.get().equals(folder) && folder instanceof OrderableEntity) {
            for (IRBC rbc : this.getRBCs()) {
                OrderableEntity folderOrderableEntity = (OrderableEntity)((Object)folder);
                folderOrderableEntity.addRBC(rbc);
            }
        }
    }

    @Override
    public List<NewMessage> getMessages() {
        return new ArrayList<NewMessage>(this.messages);
    }

    @Override
    public void addMessage(NewMessage message) {
        if (!this.messages.contains(message)) {
            this.messages.add(message);
        }
    }

    @Override
    public List<Action> getActions() {
        return new ArrayList<Action>(this.actions);
    }

    public void addAction(Action action) {
        if (!this.actions.contains(action)) {
            this.actions.add(action);
        }
    }

    @Override
    public List<InCondition> getInConditions() {
        return this.inConditionList;
    }

    @Override
    public List<OutCondition> getOutConditions() {
        return this.outConditionList;
    }

    @Override
    public List<ControlResource> getControlResources() {
        return this.controlResourceList;
    }

    @Override
    public List<IOnStatement> getOnDo() {
        return this.onDoList;
    }

    @Override
    public List<Shout> getShouts() {
        return this.shoutList;
    }

    @Override
    public List<IRBC> getRBCs() {
        return this.rbcList;
    }

    @Override
    public List<QuantitativeResource> getQuantitativeResources() {
        return this.quantitativeResourceList;
    }

    protected AbstractOrderableEntity clone() throws CloneNotSupportedException {
        AbstractOrderableEntity cloned = (AbstractOrderableEntity)super.clone();
        cloned.variablesMap = new LinkedHashMap<String, Variable>(this.variablesMap);
        cloned.attributes = new HashMap<String, String>(this.attributes);
        cloned.messages = new ArrayList<NewMessage>(this.messages);
        cloned.actions = new ArrayList<Action>(this.actions);
        cloned.inConditionList = new ArrayList<InCondition>(this.inConditionList);
        cloned.outConditionList = new ArrayList<OutCondition>(this.outConditionList);
        cloned.quantitativeResourceList = new ArrayList<QuantitativeResource>(this.quantitativeResourceList);
        cloned.controlResourceList = new ArrayList<ControlResource>(this.controlResourceList);
        cloned.onDoList = new ArrayList<IOnStatement>(this.onDoList);
        cloned.shoutList = new ArrayList<Shout>(this.shoutList);
        cloned.rbcList = new ArrayList<IRBC>(this.rbcList);
        cloned.entityName = new String(this.entityName);
        return cloned;
    }
}

