/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.io.csv;

import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.io.csv.CsvWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class DataObjectToCsvWriter {
    public static final String CHILDREN_IDS = "children ids";
    public static final String PARENT_ID = "parent id ";
    public static final String INTERNAL_ID = "internal id";
    private String[] header;
    protected CsvWriter csvWriter;

    public void write(DataObject toWrite) throws IOException {
        this.header = this.generateHeader(toWrite);
        this.csvWriter.writeRecord(this.header);
        List entList = toWrite.stream().collect(Collectors.toList());
        for (DataEntity ent : entList) {
            this.csvWriter.writeRecord(this.attributesToArray(ent, toWrite));
        }
        this.csvWriter.close();
    }

    private String[] attributesToArray(DataEntity toWrite, DataObject containingDataObj) {
        ArrayList<String> record = new ArrayList<String>();
        Integer id = toWrite.getId().getId();
        Integer parentId = null;
        if (containingDataObj.getParentOf(toWrite).isPresent()) {
            parentId = containingDataObj.getParentOf(toWrite).get().getId().getId();
        }
        ArrayList childrenIds = new ArrayList();
        containingDataObj.getChildrenOf(toWrite, e -> true).forEach(ent -> childrenIds.add(ent.getId().getId()));
        for (int i = 0; i < this.header.length; ++i) {
            if (this.header[i].equals(INTERNAL_ID)) {
                record.add(id.toString());
                continue;
            }
            if (this.header[i].equals(PARENT_ID)) {
                record.add(parentId == null ? "" : parentId.toString());
                continue;
            }
            if (this.header[i].equals(CHILDREN_IDS)) {
                record.add(((Object)childrenIds).toString());
                continue;
            }
            record.add(this.removBrackets(toWrite.getAttributes().getValuesof(this.header[i]).toString()));
        }
        return record.toArray(new String[record.size()]);
    }

    private String removBrackets(String string) {
        return string.replaceAll("^\\[", "").replaceAll("\\]$", "").trim();
    }

    private String[] generateHeader(DataObject toWrite) {
        ArrayList<String> header = new ArrayList<String>();
        header.add(INTERNAL_ID);
        header.add(PARENT_ID);
        header.add(CHILDREN_IDS);
        HashSet attributes = new HashSet();
        toWrite.stream().forEach(dataEnt -> dataEnt.getAttributes().forEach(attr -> attributes.add(attr.getName())));
        header.addAll(attributes);
        return header.toArray(new String[header.size()]);
    }

    public String[] getHeader() {
        return this.header;
    }

    public void setCsvWriter(CsvWriter csvWriter) {
        this.csvWriter = csvWriter;
    }

    public CsvWriter getCsvWriter() {
        return this.csvWriter;
    }
}

