/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.io;

import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileUtils {
    public static Charset getDraftCharset() {
        return DraftFormat.getDraftCharSet();
    }

    public static Reader createNewReader(Path path) throws IOException {
        Charset charset = FileUtils.getDraftCharset();
        InputStream stream = Files.newInputStream(path, new OpenOption[0]);
        return new InputStreamReader(stream, charset);
    }

    public static void deleteIfFileExsist(String filePathAsString) {
        Path pathToFile = Paths.get(filePathAsString, new String[0]);
        try {
            if (Files.exists(pathToFile, new LinkOption[0])) {
                Files.delete(pathToFile);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static BufferedReader createNewBufferedReader(Path path) throws IOException {
        return new BufferedReader(FileUtils.createNewReader(path));
    }

    public static Writer createNewWriter(Path path, OpenOption ... options) throws IOException {
        Charset charset = FileUtils.getDraftCharset();
        OutputStream stream = Files.newOutputStream(path, options);
        return new OutputStreamWriter(stream, charset);
    }

    public static BufferedWriter createNewBufferedWriter(Path path, OpenOption ... options) throws IOException {
        return new BufferedWriter(FileUtils.createNewWriter(path, options));
    }

    public static BufferedReader createBufferedReader(Path file, CodingErrorAction codingErrorAction) throws IOException {
        CharsetDecoder decoder = Charset.defaultCharset().newDecoder().onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction);
        InputStream in = Files.newInputStream(file, new OpenOption[0]);
        InputStreamReader reader = new InputStreamReader(in, decoder);
        return new BufferedReader(reader);
    }

    public static void deleteTree(Path toDelete) throws IOException {
        if (Files.isDirectory(toDelete, new LinkOption[0])) {
            for (Path file : Files.list(toDelete).collect(Collectors.toList())) {
                FileUtils.deleteTree(file);
            }
        }
        Files.deleteIfExists(toDelete);
    }

    public static InputStream newInputStream(String content) {
        return new ByteArrayInputStream(content.getBytes());
    }

    public static List<InputStream> getFilesInputStreamFromDirectory(Path directoryPath) throws IOException {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        try (Stream<Path> paths = Files.list(directoryPath);){
            paths.forEach(path -> {
                try {
                    InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                    inputStreams.add(inputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return inputStreams;
    }
}

