/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.interfaces;

import com.bmc.ctmconvert.base.BaseComboBox;
import com.bmc.ctmconvert.base.BaseComponentSection;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseLabel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.ImportEntryReader;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.dataimport.autofiledetect.DataForImportDetector;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.InputStream;

public interface VendorData {
    public static final VendorData NULL = new NullVendorData();
    public static final String VERSION_TEXT = "Control-M Version";

    public String getName();

    public String getDisplayName();

    public VendorType getVendorType();

    public DataImportVendor getDataImport();

    public CliImporter getCLIImporter();

    public BasePanel getAssessmentReport(String var1);

    public SourceDefinitions getSourceDefinition(BaseProgressBar var1) throws ConvertorCancelClickException;

    default public InputStream getRulesResourceFile() {
        return this.getClass().getResourceAsStream("/rules.xml");
    }

    default public boolean isZOS() {
        return false;
    }

    default public ImportEntryList getImportEntries() {
        ImportEntryList entries = null;
        InputStream entriesResource = this.getClass().getResourceAsStream("/ImportEntries.xml");
        if (entriesResource != null) {
            ImportEntryReader reader = new ImportEntryReader(ConversionEntitiesService.getCurrentProjectDataDirectory() + "User.DataImport.xml");
            entries = reader.read(entriesResource);
        }
        return entries;
    }

    default public ImportEntry getImportEntry(String id) {
        ImportEntryList entries = this.getImportEntries();
        if (entries != null) {
            for (ImportEntry entry : entries) {
                if (!id.equals(entry.getID())) continue;
                return entry;
            }
        }
        return null;
    }

    default public Importer getVendorImporter() {
        return null;
    }

    default public DataForImportDetector getDataForImportDetector() {
        return null;
    }

    default public Dimension getSize() {
        return new Dimension(670, 700);
    }

    default public String getHelpTitle(boolean isAutomatic) {
        return null;
    }

    default public DataObject getDataObject() {
        return null;
    }

    default public BaseComponentSection.Grid getVersionGridForConversionSettings(BaseField DSContromMField, BaseField ZOSControlMField, BaseComponentSection componentSection, BaseComponentSection.Grid addHorizontalGap, BaseComboBox versionsDrop, BaseTextField DSContromM, BaseTextField ZOSControlM) {
        BaseLabel versionLabel = new BaseLabel("Control-M Version: ");
        versionLabel.getComponent().setPreferredSize(null);
        versionLabel.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        int validityComponentWidth = 20;
        int componentWidth = 210;
        return addHorizontalGap.addGrid(4, 1, componentSection.createGrid(4, 5).addCell(componentSection.createCell(1, 0, versionLabel)).addCell(componentSection.createCell(3, 0, versionsDrop), componentWidth).addVerticalGap(0, 1, 6).addVerticalGap(1, 1, 6).addCell(componentSection.createCell(0, 2, DSContromMField.getMandatoryLabel()).setAnchor(22).setInsets(new Insets(0, 0, 0, 0))).addCell(componentSection.createCell(1, 2, DSContromMField.getTitleLabel())).addCell(componentSection.createCell(2, 2, DSContromM.getValidityComponent()).setAnchor(22).setInsets(new Insets(0, 0, 0, 0)), validityComponentWidth).addCell(componentSection.createCell(3, 2, DSContromM), componentWidth).addVerticalGap(0, 3, 6).addVerticalGap(1, 3, 6).addCell(componentSection.createCell(0, 4, ZOSControlMField.getMandatoryLabel()).setAnchor(22).setInsets(new Insets(0, 0, 0, 0))).addCell(componentSection.createCell(1, 4, ZOSControlMField.getTitleLabel())).addCell(componentSection.createCell(2, 4, ZOSControlM.getValidityComponent()).setAnchor(22).setInsets(new Insets(0, 0, 0, 0)), validityComponentWidth).addCell(componentSection.createCell(3, 4, ZOSControlM), componentWidth));
    }

    default public BaseComponentSection.Grid getServerNameSettings(BaseField DSContromMField, BaseField ZOSControlMField, BaseComponentSection componentSection, BaseComponentSection.Grid addHorizontalGap, BaseTextField DSContromM, BaseTextField ZOSControlM) {
        int validityComponentWidth = 20;
        int componentWidth = 210;
        return addHorizontalGap.addGrid(4, 1, componentSection.createGrid(4, 5).addCell(componentSection.createCell(0, 2, DSContromMField.getMandatoryLabel()).setAnchor(22).setInsets(new Insets(0, 0, 0, 0))).addCell(componentSection.createCell(1, 2, DSContromMField.getTitleLabel())).addCell(componentSection.createCell(2, 2, DSContromM.getValidityComponent()).setAnchor(22).setInsets(new Insets(0, 0, 0, 0)), validityComponentWidth).addCell(componentSection.createCell(3, 2, DSContromM), componentWidth).addVerticalGap(0, 3, 6).addVerticalGap(1, 3, 6).addCell(componentSection.createCell(0, 4, ZOSControlMField.getMandatoryLabel()).setAnchor(22).setInsets(new Insets(0, 0, 0, 0))).addCell(componentSection.createCell(1, 4, ZOSControlMField.getTitleLabel())).addCell(componentSection.createCell(2, 4, ZOSControlM.getValidityComponent()).setAnchor(22).setInsets(new Insets(0, 0, 0, 0)), validityComponentWidth).addCell(componentSection.createCell(3, 4, ZOSControlM), componentWidth));
    }

    default public boolean shouldBeLoaded() {
        return true;
    }

    default public RBC.WEEKDAYS getFirstDayOfTheWeek() {
        return RBC.WEEKDAYS.MONDAY;
    }

    public static class NullVendorData
    implements VendorData {
        @Override
        public String getName() {
            return "NullVendor";
        }

        @Override
        public String getDisplayName() {
            return "NullVendor";
        }

        @Override
        public VendorType getVendorType() {
            return VendorType.Other;
        }

        @Override
        public DataImportVendor getDataImport() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public CliImporter getCLIImporter() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public BasePanel getAssessmentReport(String path) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) throws ConvertorCancelClickException {
            throw new RuntimeException("Not implemented");
        }
    }

    public static enum VendorType {
        Schedulers,
        Applications,
        Other;

    }
}

