/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport.autofiledetect;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.autofiledetect.DetectFileForEntry;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public abstract class TableEntryDetector
implements DetectFileForEntry {
    @Override
    public List<String> getFilesForEntry(ImportEntry entry, List<Path> files) {
        List<String> filesFoundList = this.getFilesFoundList(files);
        String tableName = entry.getTableName();
        String normalizedTableName = this.normalizeString(tableName);
        ArrayList<String> fileList = new ArrayList<String>();
        for (String fileName : filesFoundList) {
            if (!normalizedTableName.equalsIgnoreCase(this.fileNameWithoutExtension(fileName))) continue;
            fileList.add(fileName);
            return fileList;
        }
        for (String fileName : filesFoundList) {
            if (!this.normalizeString(fileName.toLowerCase()).contains(normalizedTableName.toLowerCase())) continue;
            fileList.add(fileName);
        }
        return fileList;
    }

    protected abstract List<String> getFilesSuffixList();

    private boolean containsInSuffixList(Path file) {
        boolean contain = false;
        List<String> suffixList = this.getFilesSuffixList();
        if (suffixList.isEmpty()) {
            contain = true;
        } else {
            for (String suffix : suffixList) {
                if (!file.getFileName().toString().toLowerCase().endsWith(suffix.toLowerCase())) continue;
                contain = true;
                break;
            }
        }
        return contain;
    }

    private List<String> getFilesFoundList(List<Path> files) {
        ArrayList<String> filesName = new ArrayList<String>();
        for (Path file : files) {
            if (!Files.isRegularFile(file, new LinkOption[0]) || !this.containsInSuffixList(file)) continue;
            filesName.add(file.toAbsolutePath().toString());
        }
        return filesName;
    }

    private String fileNameWithoutExtension(String fileName) {
        int slashIndex = fileName.lastIndexOf(Globs.DIRSEP);
        return this.normalizeString(fileName.substring(slashIndex + 1, fileName.lastIndexOf(46)));
    }

    public abstract String normalizeString(String var1);
}

