/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.DirectoryFileImporter;
import com.bmc.ctmconvert.dataimport.EntriesImporter;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.ImporterType;
import com.bmc.ctmconvert.dataimport.fileimporter.FIleImporter;
import com.bmc.ctmconvert.interfaces.DefaultVendorData;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.VendorDataManager;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import org.h2.util.StringUtils;

public class VendorImporter
extends EntriesImporter {
    protected Path targetDir;
    private FileSystem fileSystem;

    public VendorImporter(ImportEntryList entries, Path targetDir) {
        this(entries, targetDir, FileSystems.getDefault());
    }

    public VendorImporter(ImportEntryList entries, Path targetDir, FileSystem fileSystem) {
        super(entries);
        this.targetDir = targetDir;
        this.fileSystem = fileSystem;
    }

    @Override
    public Progressable.ProgressStatus performImport() {
        for (ImportEntry importEntry : this.entries) {
            if (importEntry.getType().equals((Object)ImporterType.Directory)) {
                String dirName = importEntry.getDestinationFileName();
                Path newTargetDir = this.targetDir;
                if (!StringUtils.isNullOrEmpty((String)dirName)) {
                    newTargetDir = this.targetDir.resolve(dirName);
                    try {
                        Files.createDirectory(newTargetDir, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
                        ExceptionHandler.writeToExceptionFile(e);
                        break;
                    }
                }
                Path sourcePath = this.fileSystem.getPath(importEntry.getSourceFullName(), new String[0]);
                DirectoryFileImporter directoryImporter = new DirectoryFileImporter(sourcePath, newTargetDir);
                directoryImporter.addProgressListener(x$0 -> this.fireProgressEvent(x$0));
                directoryImporter.run();
                this.setStatus(directoryImporter.getStatus());
                if (directoryImporter.getStatus() == Progressable.ProgressStatus.ENDED_SUCCESS) continue;
                break;
            }
            if (!importEntry.getType().equals((Object)ImporterType.File)) continue;
            FIleImporter fileImporter = new FIleImporter(importEntry, this.fileSystem, this.targetDir);
            fileImporter.addProgressListener(x$0 -> this.fireProgressEvent(x$0));
            fileImporter.run();
            this.setStatus(fileImporter.getStatus());
            if (fileImporter.getStatus() == Progressable.ProgressStatus.ENDED_SUCCESS) continue;
            break;
        }
        return this.getStatus();
    }

    @Override
    public void postImportAction() {
        try {
            String targetPath = ConversionEntitiesService.getCurrentProjectDataObjectDirectory();
            Path target = Files.createDirectories(Paths.get(targetPath, new String[0]), new FileAttribute[0]);
            VendorData vendorData = VendorDataManager.instance().getVendorData();
            if (vendorData instanceof DefaultVendorData) {
                ((DefaultVendorData)vendorData).writeDataObjectToCsv(target);
            }
        }
        catch (IOException e) {
            ConversionLogger.getLogger().log(Level.WARNING, "Unable to create DataObject file directory.");
        }
    }
}

