/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.configuration;

import com.bmc.ctmconvert.base.ButtonColors;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import com.bmc.ctmconvert.configuration.themes.ProgressBarTheme;
import com.bmc.ctmconvert.configuration.themes.WelcomePageTheme;
import java.awt.Color;

class SaasThemeConfiguration
implements ThemeConfiguration {
    SaasThemeConfiguration() {
    }

    @Override
    public String updateGlobalVariableName(String autoEditName) {
        if (!GlobalFunctions.isPoolVariable(autoEditName)) {
            autoEditName = autoEditName.replaceAll("[^a-zA-Z]", "");
            autoEditName = String.format("\\\\global\\%s", autoEditName);
        }
        return autoEditName;
    }

    @Override
    public String getVariableDescription() {
        return "Pool Variables";
    }

    @Override
    public String updateMessagesTerminology(String messageText) {
        return ThemeConfiguration.super.updateMessagesTerminology(this.updateSaasTerminology(messageText));
    }

    private String updateSaasTerminology(String messageText) {
        return messageText.replaceAll("(?i)SMART/", "Folder/").replaceAll("(?i)SMART.Folder", "Folder").replaceAll("(?i)control resource", "mutex").replaceAll("(?i)quantitative resource", "semaphore").replaceAll("(?i)forces", "runs").replaceAll("(?i)ON DO Force", "Run").replaceAll("(?i)Shout", "Notification").replaceAll("(?i)On Do Mail action", "If Action:Mail").replaceAll("(?i)in.condition", "wait for event").replaceAll("(?i)out.condition", "add event").replaceAll("(?<=\\b)Condition(?!>)", "Event").replaceAll("(?<=\\b)condition(?!>)", "event").replaceAll("(?i)Control-M", "Control-M SaaS");
    }

    @Override
    public String processRulesContent(String content) {
        return content.replace("Shout", "Notification").replace("Do mail statement", "Action:Mail").replace("USERDAILY", "Run Method").replace("Cleanup conditions", "Delete events").replace("in conditions", "events").replaceAll("(?<=\\b)Condition", "Event").replaceAll("(?<=\\b)condition", "event").replace("Control-M", "Control-M SaaS");
    }

    @Override
    public String getImagesPrefixPath() {
        return "/img/saas/";
    }

    @Override
    public String getStepsImagesPrefixPath() {
        return "";
    }

    @Override
    public Color getHoverTextColor() {
        return SaaS.ConversionSaaSBlue;
    }

    @Override
    public Color getSelectedTabBackground() {
        return SaaS.ConversionSaaSBlue;
    }

    @Override
    public String getControlmName() {
        return "Control-M SaaS";
    }

    @Override
    public WelcomePageTheme getWelcomePageTheme() {
        WelcomePageTheme welcomePageTheme = new WelcomePageTheme();
        welcomePageTheme.backgroundColor = FlowGlobals.ConversionWhite.getRGB();
        welcomePageTheme.continueBackgroundColor = 15749925;
        welcomePageTheme.continueForegroundColor = FlowGlobals.ConversionWhite;
        welcomePageTheme.controlmName = this.getControlmName();
        welcomePageTheme.textColorHex = "37343A";
        welcomePageTheme.textColor = SaaS.BLACK_TEXT;
        welcomePageTheme.validationStepText = "";
        welcomePageTheme.videoLinkText = "";
        welcomePageTheme.continueActiveColor = SaaS.BUTTON_ACTIVE;
        return welcomePageTheme;
    }

    @Override
    public String getGuiTextFilePath() {
        return Globs.DATA_DIR + Globs.DIRSEP + "saas_gui_text.txt";
    }

    @Override
    public ProgressBarTheme getProgressBarTheme() {
        ProgressBarTheme progressBarTheme = new ProgressBarTheme();
        progressBarTheme.foregroundColor = new Color(1081509);
        progressBarTheme.backgroundColor = new Color(0xEAEAEA);
        progressBarTheme.insideBorderColor = progressBarTheme.foregroundColor;
        progressBarTheme.outsideBorderColor = new Color(0xE0E0E0);
        return progressBarTheme;
    }

    @Override
    public ButtonColors getButtonColors() {
        ButtonColors buttonColors = new ButtonColors();
        buttonColors.hoverBackgroundColor = SaaS.ConversionSaaSBlue;
        buttonColors.buttonPressedBackgroundColor = SaaS.SaaSButtonPressed;
        buttonColors.buttonPressedTextColor = FlowGlobals.ConversionWhite;
        return buttonColors;
    }

    @Override
    public String getHelpFilesPath() {
        return "https://documents.bmc.com/supportu/conversion-saas/en-US/index.htm#";
    }

    @Override
    public String getShoutDisplayName() {
        return "Notification Destination";
    }

    @Override
    public String getControlResourceDisplayName() {
        return "Mutex";
    }

    @Override
    public String getQuantitativeResourceDisplayName() {
        return "Semaphore";
    }

    public static class SaaS {
        public static final String BLACK_TEXT_HEX = "37343A";
        public static final Color BLACK_TEXT = new Color(3617850);
        public static final Color BUTTON_ACTIVE = new Color(12530706);
        public static final int BUTTON_BACKGROUND = 15749925;
        public static final Color ConversionSaaSBlue = new Color(27283);
        public static final Color SaaSButtonPressed = new Color(17505);
    }
}

