/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.xml;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.xml.predicates.ChildPredicate;
import com.bmc.ctmconvert.common.xml.predicates.ComparablePredicate;
import com.bmc.ctmconvert.common.xml.predicates.NamedTagChildPredicate;
import com.bmc.ctmconvert.common.xml.predicates.NamedTagPredicate;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlElement {
    public static final XmlElement nullXmlElement = new NullXmlElement();
    private static final String ALL_CHILDREN_ELEMENTS = "*";
    private final Element element;
    private NodeList children;
    private XmlElement parent;
    private Map<ComparablePredicate, List<XmlElement>> filtersCache = new HashMap<ComparablePredicate, List<XmlElement>>();

    private XmlElement() {
        this.element = null;
        this.children = null;
    }

    public XmlElement(Element element) {
        this.element = element;
        this.filtersCache = new HashMap<ComparablePredicate, List<XmlElement>>();
        if (this.element != null) {
            this.children = this.element.getElementsByTagName(ALL_CHILDREN_ELEMENTS);
            Node parentNode = this.element.getParentNode();
            if (parentNode != null && parentNode.getNodeType() == 1) {
                this.parent = new XmlElement((Element)parentNode);
            }
        } else {
            this.children = null;
        }
    }

    public static XmlElement fromDocument(Document document) {
        return new XmlElement(document.getDocumentElement());
    }

    public static XmlElement ofNullable(Element element) {
        if (element == null) {
            return nullXmlElement;
        }
        return new XmlElement(element);
    }

    public List<XmlElement> filterAndReturnXmlElement(ComparablePredicate filter) {
        if (this.filtersCache.containsKey(filter)) {
            return this.filtersCache.get(filter);
        }
        ArrayList<XmlElement> matchingList = new ArrayList<XmlElement>();
        NodeList items = this.element.getElementsByTagName(ALL_CHILDREN_ELEMENTS);
        int length = items.getLength();
        for (int index = 0; index < length; ++index) {
            Node currentNode = items.item(index);
            Element nodeAsElement = (Element)currentNode;
            if (!filter.test(nodeAsElement)) continue;
            XmlElement nodeAsXmlElement = new XmlElement(nodeAsElement);
            matchingList.add(nodeAsXmlElement);
        }
        this.filtersCache.put(filter, matchingList);
        return matchingList;
    }

    public List<XmlElement> getDirectchildsElementbyName(String ... elementsTagName) {
        ArrayList<XmlElement> result = new ArrayList<XmlElement>();
        for (String tagName : elementsTagName) {
            List<XmlElement> tempList = this.getDirectchildsElementbyName(tagName);
            result.addAll(tempList);
        }
        return result;
    }

    public List<XmlElement> getDirectchildsElementbyName(String tagName) {
        return this.filterAndReturnXmlElement(this.getPredicateToMatchNamedChildTags(tagName));
    }

    private ComparablePredicate getPredicateToMatchNamedChildTags(String tagName) {
        return new NamedTagChildPredicate(tagName, this.element);
    }

    public List<XmlElement> getAllDirectchildsElement() {
        return this.filterAndReturnXmlElement(this.getPredicateToMatchAllChildTags());
    }

    private ComparablePredicate getPredicateToMatchAllChildTags() {
        return new ChildPredicate(this.element);
    }

    public String getAttribute(String xmlAttr) {
        return this.element.getAttribute(xmlAttr);
    }

    public void setAttribute(String xmlAttr, String value) {
        this.element.setAttribute(xmlAttr, value);
    }

    public ArrayList<String> getDirectChildsElementAttrByName(String elementTagName, String elementAttributeName) {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlElement> elementList = this.getDirectchildsElementbyName(elementTagName);
        for (XmlElement xmlElement : elementList) {
            String attributeValue = xmlElement.getAttribute(elementAttributeName);
            if (attributeValue.isEmpty()) continue;
            result.add(attributeValue);
        }
        return result;
    }

    public Element getElement() {
        return this.element;
    }

    public XmlElement getFirstChildElementByName(String singleElementTagName) {
        List<XmlElement> childElementList = this.getDirectchildsElementbyName(singleElementTagName);
        if (!childElementList.isEmpty()) {
            return childElementList.get(0);
        }
        return null;
    }

    public List<XmlElement> getAllDecnedElementByName(String tagName) {
        return this.filterAndReturnXmlElement(this.getPredicateToMatchNamedTagPredicate(tagName));
    }

    public XmlElement getFirstChild(String tagName) {
        for (int index = 0; index < this.children.getLength(); ++index) {
            Element node = (Element)this.children.item(index);
            if (!tagName.equals(node.getTagName())) continue;
            return new XmlElement(node);
        }
        return null;
    }

    public String getFirstChildValue(String tagName) {
        XmlElement node = this.getFirstChild(tagName);
        return node == null ? null : node.getValue();
    }

    private ComparablePredicate getPredicateToMatchNamedTagPredicate(String tagName) {
        return new NamedTagPredicate(tagName, this.element);
    }

    public boolean hasChild(String childTagName) {
        XmlElement child = this.getFirstChildElementByName(childTagName);
        return child != null;
    }

    public LinkedHashMap<String, String> getDirectChildsElementKeyVAlueAttrByName(String ElementTagName, String keyAttrName, String valueAttrName) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List<XmlElement> elementList = this.getDirectchildsElementbyName(ElementTagName);
        for (XmlElement xmlElement : elementList) {
            if (xmlElement.getAttribute(keyAttrName).isEmpty()) continue;
            String key = xmlElement.getAttribute(keyAttrName);
            String value = xmlElement.getAttribute(valueAttrName);
            result.put(key, value);
        }
        return result;
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public String getValue() {
        return this.element.getTextContent();
    }

    public String toString() {
        String xmlString = "";
        try {
            xmlString = this.transformElementToString(TransformerFactory.newInstance().newTransformer());
        }
        catch (TransformerException | TransformerFactoryConfigurationError te) {
            ExceptionHandler.writeToExceptionFile("XML Transformer serious glitch - " + String.valueOf(te));
        }
        return xmlString;
    }

    private String transformElementToString(Transformer transformer) throws TransformerException {
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(this.element);
        transformer.transform(source, result);
        String xmlString = result.getWriter().toString();
        return xmlString;
    }

    public XmlElement getFirstChildElementByAttrValue(String tagName, String attrName, String attrValue) {
        List<XmlElement> elementList = this.getDirectchildsElementbyName(tagName);
        for (XmlElement xmlElement : elementList) {
            if (!xmlElement.getAttribute(attrName).equals(attrValue)) continue;
            return xmlElement;
        }
        return null;
    }

    public boolean hasAttribute(String attrValue) {
        return this.element.hasAttribute(attrValue);
    }

    public boolean hasAttributeWithValue(String keyAttrName, String valueAttrName) {
        boolean result = false;
        if (this.hasAttribute(keyAttrName)) {
            result = valueAttrName.equals(this.element.getAttribute(keyAttrName));
        }
        return result;
    }

    public String getValueOfFirstChildElementByName(String ... tagName) {
        String result = "";
        for (String string : tagName) {
            String element = this.getValueOfFirstChildElementByName(string);
            if (result.equals(element)) continue;
            result = element;
            break;
        }
        return result;
    }

    public String getValueOfFirstChildElementByName(String tagName) {
        XmlElement element = this.getFirstChildElementByName(tagName);
        if (element == null) {
            return "";
        }
        return element.getValue();
    }

    public List<XmlElement> getAllDecnedElementByMultipleName(String ... tagNamesArray) {
        ArrayList<XmlElement> decenededElementList = new ArrayList<XmlElement>();
        for (String currentTagName : tagNamesArray) {
            decenededElementList.addAll(this.getAllDecnedElementByName(currentTagName));
        }
        return decenededElementList;
    }

    public ArrayList<String> getAllDecnedValuesByMultipleName(String ... tagNamesArray) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<XmlElement> decenededElementList = new ArrayList<XmlElement>();
        for (String currentTagName : tagNamesArray) {
            decenededElementList.addAll(this.getAllDecnedElementByName(currentTagName));
        }
        for (XmlElement xmlElement : decenededElementList) {
            list.add(xmlElement.getValue());
        }
        return list;
    }

    public Map<String, String> getAttributes() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        NamedNodeMap attributes = this.element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String attrName = attr.getNodeName();
            String attrValue = attr.getNodeValue();
            ret.put(attrName, attrValue);
        }
        return ret;
    }

    public void moveDfs(Consumer<XmlElement> consumer) {
        for (XmlElement child : this.getAllDirectchildsElement()) {
            child.moveDfs(consumer);
        }
        consumer.accept(this);
    }

    public String getText() {
        return this.element == null ? "" : this.element.getTextContent();
    }

    public int hashCode() {
        return this.element != null ? this.element.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof XmlElement) {
            boolean exactlyOneOfElementsIsNull;
            if (obj == nullXmlElement) {
                return false;
            }
            XmlElement other = (XmlElement)obj;
            Element otherElement = other.getElement();
            boolean bl = exactlyOneOfElementsIsNull = otherElement == null && this.element != null || otherElement != null && this.element == null;
            if (exactlyOneOfElementsIsNull) {
                return false;
            }
            if (otherElement == null && this.element == null) {
                return true;
            }
            boolean isSameNode = this.element.isEqualNode(otherElement);
            if (this.element == otherElement || isSameNode) {
                result = true;
            }
        }
        return result;
    }

    public XmlElement getParent() {
        return this.parent;
    }

    public String getCData() {
        NodeList list = this.element.getChildNodes();
        for (int index = 0; index < list.getLength(); ++index) {
            CharacterData child;
            String data;
            if (!(list.item(index) instanceof CharacterData) || (data = (child = (CharacterData)list.item(index)).getData()) == null || data.trim().length() <= 0) continue;
            return data.trim();
        }
        return "";
    }

    public void removeChild(XmlElement jobSkeleton) {
        this.element.removeChild(jobSkeleton.getElement());
        this.clearCache();
    }

    public Optional<XmlElement> findParent(Predicate<XmlElement> predicate) {
        XmlElement parent = this.getParent();
        if (parent == null || parent == nullXmlElement) {
            return Optional.empty();
        }
        if (predicate.test(parent)) {
            return Optional.ofNullable(parent);
        }
        return parent.findParent(predicate);
    }

    public XmlElement addChildAt(XmlElement newChildNode, int position) {
        if (newChildNode != nullXmlElement) {
            Node firstDocImportedNode = this.element.getOwnerDocument().importNode(newChildNode.getElement(), true);
            List<XmlElement> children = this.getAllDirectchildsElement();
            if (children.size() > position) {
                this.element.insertBefore(firstDocImportedNode, children.get(position).getElement());
            } else if (position == 0) {
                this.element.appendChild(firstDocImportedNode);
            }
            this.clearCache();
        }
        return this;
    }

    public XmlElement prependChild(XmlElement newChildNode) {
        return this.addChildAt(newChildNode, 0);
    }

    private void clearCache() {
        this.filtersCache.clear();
        if (this.element != null) {
            this.children = this.element.getElementsByTagName(ALL_CHILDREN_ELEMENTS);
        }
    }

    private static class NullXmlElement
    extends XmlElement {
        private NullXmlElement() {
        }

        @Override
        public XmlElement addChildAt(XmlElement newChildNode, int position) {
            return this;
        }

        @Override
        public List<XmlElement> filterAndReturnXmlElement(ComparablePredicate filter) {
            return Collections.emptyList();
        }

        @Override
        public List<XmlElement> getDirectchildsElementbyName(String ... elementsTagName) {
            return Collections.emptyList();
        }

        @Override
        public List<XmlElement> getDirectchildsElementbyName(String tagName) {
            return Collections.emptyList();
        }

        @Override
        public List<XmlElement> getAllDirectchildsElement() {
            return Collections.emptyList();
        }

        @Override
        public String getAttribute(String xmlAttr) {
            return "";
        }

        @Override
        public void setAttribute(String xmlAttr, String value) {
        }

        @Override
        public ArrayList<String> getDirectChildsElementAttrByName(String elementTagName, String elementAttributeName) {
            return new ArrayList<String>(Collections.emptyList());
        }

        @Override
        public Element getElement() {
            return null;
        }

        @Override
        public XmlElement getFirstChildElementByName(String singleElementTagName) {
            return this;
        }

        @Override
        public List<XmlElement> getAllDecnedElementByName(String tagName) {
            return Collections.emptyList();
        }

        @Override
        public boolean hasChild(String childTagName) {
            return false;
        }

        @Override
        public LinkedHashMap<String, String> getDirectChildsElementKeyVAlueAttrByName(String ElementTagName, String keyAttrName, String valueAttrName) {
            return new LinkedHashMap<String, String>(Collections.emptyMap());
        }

        @Override
        public String getTagName() {
            return "";
        }

        @Override
        public String getValue() {
            return "";
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public XmlElement getFirstChildElementByAttrValue(String tagName, String attrName, String attrValue) {
            return this;
        }

        @Override
        public boolean hasAttribute(String attrValue) {
            return false;
        }

        @Override
        public boolean hasAttributeWithValue(String keyAttrName, String valueAttrName) {
            return false;
        }

        @Override
        public String getValueOfFirstChildElementByName(String ... tagName) {
            return "";
        }

        @Override
        public String getValueOfFirstChildElementByName(String tagName) {
            return "";
        }

        @Override
        public List<XmlElement> getAllDecnedElementByMultipleName(String ... tagNamesArray) {
            return Collections.emptyList();
        }

        @Override
        public ArrayList<String> getAllDecnedValuesByMultipleName(String ... tagNamesArray) {
            return new ArrayList<String>(Collections.emptyList());
        }

        @Override
        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        @Override
        public void moveDfs(Consumer<XmlElement> consumer) {
        }

        @Override
        public String getText() {
            return "";
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public XmlElement getParent() {
            return this;
        }

        @Override
        public String getCData() {
            return "";
        }

        @Override
        public void removeChild(XmlElement jobSkeleton) {
        }
    }
}

