/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.file_watcher;

import com.bmc.ctmconvert.common.SchedEntity;

public class FileWatcherWrapper {
    private final SchedEntity entity;

    public FileWatcherWrapper(SchedEntity entity) {
        this.entity = entity;
    }

    public FileWatcherWrapper convert() {
        this.initDefaults();
        return this;
    }

    private void initDefaults() {
        this.entity.addAttribute("APPL_TYPE", "FileWatch");
        this.entity.addAttribute("APPL_FORM", "File Watcher");
        this.entity.addAutoEdits("%%FileWatch-MIN_DET_SIZE", "0");
        this.entity.addAutoEdits("%%FileWatch-INT_FILE_SEARCHES", "60");
        this.entity.addAutoEdits("%%FileWatch-INT_FILESIZE_COMPARISON", "10");
        this.entity.addAutoEdits("%%FileWatch-NUM_OF_ITERATIONS", "3");
        this.entity.addAutoEdits("%%FileWatch-TIME_LIMIT", "0");
        this.entity.addAutoEdits("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
        this.entity.addAutoEdits("%%FileWatch-MAX_AGE", "NO_MAX_AGE");
        this.entity.addAutoEdits("%%FileWatch-PATH", "Not in use for File Watcher jobs");
        this.entity.addAutoEdits("%%FileWatch-MODE", "CREATE");
        this.entity.addAutoEdits("%%FileWatch-FILESIZE_WILDCARD", "N");
        this.entity.addAutoEdits("%%FileWatch-START_TIME", "NOW");
        this.entity.addAutoEdits("%%FileWatch-STOP_TIME", "0");
    }

    public FileWatcherWrapper setPath(String path) {
        this.entity.addAutoEdits("%%FileWatch-FILE_PATH", path);
        this.setWildCard(path);
        return this;
    }

    public FileWatcherWrapper setType(Type type) {
        this.entity.addAutoEdits("%%FileWatch-MODE", type.toString());
        return this;
    }

    public FileWatcherWrapper setMinimumDestinationSize(int size, Unit unit) {
        this.entity.addAutoEdits("%%FileWatch-MIN_DET_SIZE", size + unit.toString());
        return this;
    }

    public FileWatcherWrapper setSearchInterval(int searchIntervalInSeconds) {
        this.entity.addAutoEdits("%%FileWatch-INT_FILE_SEARCHES", String.valueOf(searchIntervalInSeconds));
        return this;
    }

    private void setWildCard(String path) {
        boolean hasWildCard;
        boolean bl = hasWildCard = path.contains("*") || path.contains("?");
        if (hasWildCard) {
            this.entity.addAutoEdits("%%FileWatch-FILESIZE_WILDCARD", "Y");
        }
    }

    public static enum Type {
        CREATE,
        DELETE;


        public String toString() {
            return super.toString();
        }
    }

    public static enum Unit {
        BYTES,
        KB,
        MB,
        GB;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "B";
                case 1 -> "K";
                case 2 -> "M";
                case 3 -> "G";
            };
        }
    }
}

