/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.rerun;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.generated.json.models.base.rerun.RerunIntervals;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RerunIntervalsAdapter {
    private final SchedEntity schedEntity;

    public RerunIntervalsAdapter(SchedEntity schedEntity) {
        this.schedEntity = schedEntity;
    }

    public Optional<RerunIntervals> getRerun() {
        return Optional.ofNullable(this.schedEntity.getAttr("CYCLIC_INTERVAL_SEQUENCE")).map(intervalSequence -> new RerunIntervals().withFrom(this.getFrom()).withIntervals(this.getIntervals((String)intervalSequence)));
    }

    private List<String> getIntervals(String intervalSequence) {
        Predicate<String> isEmptyInterval = interval -> interval.matches("^0[DHM]");
        return Optional.ofNullable(intervalSequence).map(i -> i.split(",")).map(intervalString -> Arrays.stream(intervalString).map(i -> i.replaceAll("^[+-](.*)$", "$1")).map(i -> isEmptyInterval.test((String)i) ? i : StringUtils.stripStart((String)i, (String)"0")).collect(Collectors.toList())).orElse(null);
    }

    private RerunIntervals.From getFrom() {
        return Optional.ofNullable(this.schedEntity.getAttr("IND_CYCLIC")).map(from -> {
            if (from.startsWith("E")) {
                return RerunIntervals.From.END;
            }
            if (from.startsWith("T")) {
                return RerunIntervals.From.TARGET;
            }
            return RerunIntervals.From.START;
        }).orElse(RerunIntervals.From.START);
    }
}

