/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopBaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopOptionsFactory;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.BaseHadoopJob;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopOption;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopPigJob;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class HadoopPigJobAdapter
extends HadoopBaseJobAdapter<HadoopPigJob.Type> {
    private static final Pattern PIG_PARAMETERS_PATTERN = Pattern.compile("HDP-PIG_PARAM-N([0-9]{3})-(VAL|NAME)");

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.getAllUsedVariablesInHadoopBasejob();
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getPigScript()));
        Stream.ofNullable(this.getParameters()).forEach(option -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(option.toString())));
        return usedVariablesFromStr;
    }

    public HadoopPigJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    protected BaseHadoopJob buildBaseHadoopJob() {
        return new HadoopPigJob().withPigScript(this.getPigScript()).withParameters(this.getParameters());
    }

    private List<HadoopOption> getParameters() {
        return new HadoopOptionsFactory().getOptions(this.getVariablesAdapter(), PIG_PARAMETERS_PATTERN);
    }

    private String getPigScript() {
        return this.schedEntity.getVariable("%%HDP-PIG_PROG_NAME");
    }

    @Override
    public HadoopPigJob.Type getType() {
        return HadoopPigJob.Type.JOB_HADOOP_PIG;
    }
}

