/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.actions;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.actions.IfFactory;
import com.bmc.ctmconvert.generated.json.models.base.JobProperties;
import com.bmc.ctmconvert.generated.json.models.if_schema.If;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class OnStatementsAdapter {
    private final SchedEntity schedEntity;

    public OnStatementsAdapter(SchedEntity schedEntity) {
        this.schedEntity = schedEntity;
    }

    private static LinkedHashMap<List<Properties>, List<Properties>> combineConsecutiveOnDoStatementsWithAndOrRelation(LinkedHashMap<List<Properties>, List<Properties>> accumulator, Map.Entry<Properties, List<Properties>> nextOnDoStatement) {
        Properties nextOnStatement = nextOnDoStatement.getKey();
        Optional<Map.Entry<List<Properties>, List<Properties>>> lastOnDoStatement = GlobalFunctions.getLastItemFrom(accumulator.entrySet());
        if (OnStatementsAdapter.shouldBeCombined(lastOnDoStatement).booleanValue()) {
            lastOnDoStatement.ifPresent(onDoStatement -> {
                List combinedDoStatements = Stream.concat(((List)onDoStatement.getValue()).stream(), ((List)nextOnDoStatement.getValue()).stream()).collect(Collectors.toList());
                List onStatement = (List)onDoStatement.getKey();
                onStatement.add(nextOnStatement);
                onDoStatement.setValue(combinedDoStatements);
            });
        } else {
            ArrayList<Properties> onStatement = new ArrayList<Properties>(List.of(nextOnStatement));
            List<Properties> doStatements = nextOnDoStatement.getValue();
            accumulator.put(onStatement, doStatements);
        }
        return accumulator;
    }

    private Stream<Object> splitOnStatementWithAndOrOperator(IfFactory ifFactory, Properties onStatement) {
        Optional<String> optionalAndOrOperator = Optional.ofNullable(onStatement).map(on -> on.getProperty("AND_OR")).map(andOr -> switch (andOr) {
            case "O" -> "OR";
            case "A" -> "AND";
            default -> "AND";
        });
        return Stream.concat(Stream.of(ifFactory.createAnIf(onStatement)), optionalAndOrOperator.stream());
    }

    public void addEntityOnStatements(JobProperties jobProperties) {
        List<Object> ifs = this.convertIfs();
        for (int i = 0; i < ifs.size(); ++i) {
            jobProperties.setAdditionalProperty("If_" + i, ifs.get(i));
        }
    }

    private LinkedHashMap<List<Properties>, List<Properties>> combineOnStatements(LinkedHashMap<Properties, List<Properties>> onDos) {
        return onDos.entrySet().stream().reduce(new LinkedHashMap(), OnStatementsAdapter::combineConsecutiveOnDoStatementsWithAndOrRelation, (l, r) -> null);
    }

    @NotNull
    private static Boolean shouldBeCombined(Optional<Map.Entry<List<Properties>, List<Properties>>> onDoStatement) {
        return onDoStatement.map(onDo -> {
            List onStatements = (List)onDo.getKey();
            return ((Properties)GlobalFunctions.getLastItemOf(onStatements)).getProperty("AND_OR") != null;
        }).orElse(false);
    }

    private List<Object> convertIfs() {
        List<Object> ifStatementList;
        if (this.schedEntity.getOnDoStmt() != null && !this.schedEntity.getOnDoStmt().isEmpty()) {
            LinkedHashMap<List<Properties>, List<Properties>> combinedOnDoStatements = this.combineOnStatements(this.schedEntity.getOnDoStmt());
            ifStatementList = combinedOnDoStatements.entrySet().stream().map(onDoStatements -> {
                List onStatements = (List)onDoStatements.getKey();
                List doList = (List)onDoStatements.getValue();
                return this.convertToIfAction(onStatements, doList);
            }).collect(Collectors.toList());
        } else {
            ifStatementList = this.getOnStatements().stream().map(on -> this.convertToIfAction(List.of(on), Collections.singletonList(on))).collect(Collectors.toList());
        }
        return ifStatementList;
    }

    public Object convertToIfAction(List<Properties> onStatements, List<Properties> actionList) {
        IfFactory ifFactory = this.createIfFactory(this.schedEntity);
        AtomicInteger ifsCounter = new AtomicInteger();
        if (this.schedEntity.isDSJob()) {
            If anIf = ifFactory.createAnIf(onStatements.get(0));
            actionList.forEach(action -> ifFactory.addAction(anIf, ifsCounter.getAndIncrement(), (Properties)action));
            return anIf;
        }
        IfCollection ifCollection = new IfCollection().withType(OnStatementsAdapter.getZosIfCollectionType(this.schedEntity)).withIfs(this.createIfs(onStatements, ifFactory));
        actionList.forEach(action -> {
            Map.Entry<String, ?> actionEntry = ifFactory.createActionEntry(ifsCounter.getAndIncrement(), (Properties)action);
            ifCollection.setAdditionalProperty(actionEntry.getKey(), actionEntry.getValue());
        });
        return ifCollection;
    }

    @NotNull
    private static IfCollection.Type getZosIfCollectionType(SchedEntity entity) {
        return entity.isJob() ? IfCollection.Type.IF_COLLECTION_Z_OS : IfCollection.Type.IF_COLLECTION_Z_OS_FOLDER;
    }

    @NotNull
    private List<Object> createIfs(List<Properties> onStatements, IfFactory ifFactory) {
        return onStatements.stream().flatMap(onStatement -> this.splitOnStatementWithAndOrOperator(ifFactory, (Properties)onStatement)).collect(Collectors.toList());
    }

    public IfFactory createIfFactory(SchedEntity schedEntity) {
        return new IfFactory(schedEntity);
    }

    private List<Properties> getOnStatements() {
        return Optional.ofNullable(this.schedEntity.getOnStmt()).orElse(Collections.emptyList());
    }
}

