/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SapBWProcessChainAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SapR3CopyJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SapR3CreateJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapterFactory;

public class SapJobAdapterFactory {
    private SapJobAdapterFactory() {
    }

    public static SchedEntityAdapter<?> createSapJobAdapter(SchedEntity entity, SchedEntity parent) {
        if (SapJobAdapterFactory.isSapR3CopyJob(entity)) {
            return new SapR3CopyJobAdapter(entity, parent);
        }
        if (SapJobAdapterFactory.isSapBWProcessChain(entity)) {
            return new SapBWProcessChainAdapter(entity, parent);
        }
        if (SapJobAdapterFactory.isSapR3CreateJob(entity)) {
            return new SapR3CreateJobAdapter(entity, parent);
        }
        return SchedEntityAdapterFactory.convertUnsupportedEntityToDummy(entity, parent);
    }

    private static boolean isSapR3CreateJob(SchedEntity entity) {
        return "SAP R3".equals(entity.getAttr("APPL_FORM")) && "CREATE".equals(entity.getVariable("%%SAPR3-JOB_MODE"));
    }

    private static boolean isSapBWProcessChain(SchedEntity entity) {
        return "SAP Business Warehouse".equals(entity.getAttr("APPL_FORM")) && "ProcessChain".equals(entity.getVariable("%%SAPR3-PROCESS_TYPE"));
    }

    public static boolean isSapJob(SchedEntity entity) {
        return "SAP".equals(entity.getAttr("APPL_TYPE"));
    }

    private static boolean isSapR3CopyJob(SchedEntity entity) {
        return "SAP R3".equals(entity.getAttr("APPL_FORM")) && "RUN_COPY".equals(entity.getVariable("%%SAPR3-JOB_MODE"));
    }
}

