/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JobPropertiesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.generated.json.models.base.JobProperties;
import com.bmc.ctmconvert.generated.json.models.base.Variable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SaasJobPropertiesAdapter
extends JobPropertiesAdapter {
    private final Supplier<Set<String>> getUsedVariablesFunc;

    public SaasJobPropertiesAdapter(SchedEntity schedEntity, SchedEntity parent, VariablesAdapter variablesAdapter, Supplier<Set<String>> getUsedVariablesFunc) {
        super(schedEntity, parent, variablesAdapter);
        this.getUsedVariablesFunc = getUsedVariablesFunc;
    }

    @Override
    public JobProperties addJobPropertiesFields(JobProperties jobProperties) {
        super.addJobPropertiesFields(jobProperties);
        this.issueMessageForUnsupportedTimezone(jobProperties);
        Set<String> usedVars = this.getUsedVariablesFunc.get();
        Set<String> allDefinedVariablesInEntityAndItsParents = this.getAllDefinedVariablesInEntityAndItsParents(this.schedEntity);
        if (!allDefinedVariablesInEntityAndItsParents.containsAll(usedVars)) {
            this.addVariables(jobProperties, List.of(new Variable().withAdditionalProperty("POOLSYM", (Object)"Global")));
        }
        return jobProperties.withTimeZone(null);
    }

    public void issueMessageForUnsupportedTimezone(JobProperties jobProperties) {
        if (jobProperties.getTimeZone() != null) {
            Reporter.addMessage(this.schedEntity.getMessages(), "WRN20000", this.schedEntity.getJobName(), this.schedEntity.getOriginalJobName(), this.schedEntity.getJobName(), jobProperties.getTimeZone());
        }
    }

    protected Set<String> getAllDefinedVariablesInEntityAndItsParents(SchedEntity parent) {
        HashSet<String> variableSet = new HashSet<String>();
        if (parent != null) {
            variableSet.addAll(this.getVariablesNameFromEntity(parent));
            variableSet.addAll(this.getOnDoVariablesNameFromEntity(parent));
            variableSet.addAll(this.getAllDefinedVariablesInEntityAndItsParents(parent.getParent()));
        }
        return variableSet;
    }

    @NotNull
    private Set<String> getVariablesNameFromEntity(SchedEntity parent) {
        return Optional.ofNullable(parent.getAutoedits()).orElse(new LinkedHashMap()).keySet().stream().map(varName -> varName.replace("%%", "")).collect(Collectors.toSet());
    }

    private Set<String> getOnDoVariablesNameFromEntity(SchedEntity parent) {
        return Optional.ofNullable(parent.getOnDoStmt()).orElse(new LinkedHashMap()).values().stream().flatMap(it -> it.stream()).filter(prop -> prop.containsKey("VARIABLE")).map(prop -> prop.get("VARIABLE").toString().replace("%%", "")).collect(Collectors.toSet());
    }
}

