/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.DetectSpawnedJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.BaseSapR3Job;
import com.bmc.ctmconvert.generated.json.models.job_types.DetectSpawnedJob;
import com.bmc.ctmconvert.generated.json.models.job_types.PostJobAction;
import com.bmc.ctmconvert.generated.json.models.job_types.SapSteps.OutputOptions;
import java.util.List;
import java.util.Optional;

public abstract class BaseSapR3JobAdapter<T>
extends BaseJobAdapter<T> {
    protected BaseSapR3JobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    protected BaseJob buildBaseJob() {
        BaseSapR3Job baseSapR3Job = this.buildBaseSapJob().withConnectionProfile(this.schedEntity.getVariable("%%SAPR3-ACCOUNT")).withSapJobName(this.schedEntity.getVariable("%%SAPR3-JOBNAME")).withExec(this.getExecType()).withPostJobAction(this.getPostJobAction()).withDetectSpawnedJob(this.getDetectSpawnedJob());
        this.getCopyFromStep().ifPresent(arg_0 -> ((BaseSapR3Job)baseSapR3Job).setCopyFromStep(arg_0));
        this.getTarget().ifPresent(arg_0 -> ((BaseSapR3Job)baseSapR3Job).setTarget(arg_0));
        this.getStartCondition().ifPresent(arg_0 -> ((BaseSapR3Job)baseSapR3Job).setStartCondition(arg_0));
        this.getAfterEvent().ifPresent(arg_0 -> ((BaseSapR3Job)baseSapR3Job).setAfterEvent(arg_0));
        this.getAfterEventParameters().ifPresent(arg_0 -> ((BaseSapR3Job)baseSapR3Job).setAfterEventParameters(arg_0));
        this.getRerunFromPointOfFailure().ifPresent(arg_0 -> ((BaseSapR3Job)baseSapR3Job).setRerunFromPointOfFailure(arg_0));
        return baseSapR3Job;
    }

    protected abstract BaseSapR3Job buildBaseSapJob();

    private Optional<String> getAfterEventParameters() {
        return this.getVariablesAdapter().getVariableByName("%%SAPR3-EVENT_PARAM");
    }

    private Optional<String> getAfterEvent() {
        return this.getVariablesAdapter().getVariableByName("%%SAPR3-EVENT_ID");
    }

    private Optional<String> getTarget() {
        return this.getVariablesAdapter().getVariableByName("%%SAPR3-TARGET_SERVER");
    }

    private BaseSapR3Job.Exec getExecType() {
        return this.getVariablesAdapter().getVariableByName("%%SAPR3-SERVER_OR_GROUP_TYPE").filter("G"::equals).map(option -> BaseSapR3Job.Exec.GROUP).orElse(BaseSapR3Job.Exec.SERVER);
    }

    private Optional<BaseSapR3Job.StartCondition> getStartCondition() {
        Optional<String> jobCountOption = this.getVariablesAdapter().getVariableByName("%%SAPR3-SUBMIT_ASAP");
        return switch (jobCountOption.orElse("")) {
            case "E" -> Optional.of(BaseSapR3Job.StartCondition.AFTER_EVENT);
            case "X" -> Optional.of(BaseSapR3Job.StartCondition.ASAP);
            case "N" -> Optional.of(BaseSapR3Job.StartCondition.IMMEDIATE);
            default -> Optional.empty();
        };
    }

    private DetectSpawnedJob getDetectSpawnedJob() {
        return new DetectSpawnedJobAdapter(this.getVariablesAdapter(), this.schedEntity.getJobName()).getDetectSpawnedJob();
    }

    protected Optional<Boolean> variableToBoolean(String variable, String trueValue, String falseValue) {
        String spoolSaveToPdf = this.getVariablesAdapter().getVariableByName(variable).orElse("");
        if (trueValue.equals(spoolSaveToPdf)) {
            return Optional.of(true);
        }
        if (falseValue.equals(spoolSaveToPdf)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private Optional<Boolean> getRerunFromPointOfFailure() {
        return this.variableToBoolean("%%SAPR3-RERUN_FROM_POF", "Y", "N");
    }

    private Optional<String> getCopyFromStep() {
        return this.getVariablesAdapter().getVariableByName("%%SAPR3-START_STEP");
    }

    private PostJobAction getPostJobAction() {
        PostJobAction postJobAction = new PostJobAction().withSpool(this.getSpool()).withJobLog(this.getJobLog());
        this.getSpoolFile().ifPresent(arg_0 -> ((PostJobAction)postJobAction).setSpoolFile(arg_0));
        this.getSpoolSaveToPDF().ifPresent(arg_0 -> ((PostJobAction)postJobAction).setSpoolSaveToPDF(arg_0));
        this.getJobLogFile().ifPresent(arg_0 -> ((PostJobAction)postJobAction).setJobLogFile(arg_0));
        this.getJobCompletionStatus().ifPresent(arg_0 -> ((PostJobAction)postJobAction).setJobCompletionStatusWillDependOnApplicationStatus(arg_0));
        return postJobAction;
    }

    private Optional<Boolean> getJobCompletionStatus() {
        return this.variableToBoolean("%%SAPR3-INC_APP_STAT", "yes", "no");
    }

    private Optional<String> getJobLogFile() {
        if (this.getJobLog().equals((Object)OutputOptions.COPY_TO_FILE)) {
            return this.getVariablesAdapter().getVariableByName("%%SAPR3-JOBLOG");
        }
        return Optional.empty();
    }

    private OutputOptions getJobLog() {
        return this.getVariablesAdapter().getVariableByName("%%SAPR3-JOBLOG").map(action -> "*SYSOUT".equals(action) ? OutputOptions.COPY_TO_OUTPUT : OutputOptions.COPY_TO_FILE).orElse(OutputOptions.DO_NOT_COPY);
    }

    private Optional<Boolean> getSpoolSaveToPDF() {
        return this.variableToBoolean("%%SAPR3-SPOOL_AS_PDF", "Y", "N");
    }

    private Optional<String> getSpoolFile() {
        if (this.getSpool().equals((Object)OutputOptions.COPY_TO_FILE)) {
            return this.getVariablesAdapter().getVariableByName("%%SAPR3-SPOOL");
        }
        return Optional.empty();
    }

    private OutputOptions getSpool() {
        return this.getVariablesAdapter().getVariableByName("%%SAPR3-SPOOL").map(action -> "*SYSOUT".equals(action) ? OutputOptions.COPY_TO_OUTPUT : OutputOptions.COPY_TO_FILE).orElse(OutputOptions.DO_NOT_COPY);
    }

    protected static boolean isSapSelected(List<VariableWrapper> variables, String attribute) {
        String value = VariablesAdapter.getParameterFrom(variables, attribute);
        return "X".equals(value);
    }

    protected static boolean isSapSelected(SchedEntity entity, String attribute) {
        String value = entity.getAutoedits().get(attribute);
        return "X".equals(value);
    }
}

