/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface DraftWriter {
    public void writeDraft(Writer var1) throws ConvertorException, ConvertorCancelClickException, IOException;

    default public String getUserDailyFromTableID(String tableID) {
        String[] tableIDArr = tableID.split("\\$", 2);
        return tableIDArr[1];
    }

    default public String getTableNameFromTableID(String tableID) {
        String[] tableIDArr = tableID.split("\\$", 2);
        return tableIDArr[0];
    }

    default public Map<String, List<SchedEntity>> getStandaloneAndAssistingJobs(List<SchedEntity> standaloneAndAssisting, SourceDefinitions sourceDefinitions) {
        HashMap<String, List<SchedEntity>> saMap = new HashMap<String, List<SchedEntity>>();
        for (SchedEntity saj : standaloneAndAssisting) {
            String parentTable;
            String userdaily = saj.getAttr("TABLE_USERDAILY");
            if (userdaily == null) {
                userdaily = "SYSTEM";
            }
            if (sourceDefinitions.isStandAloneGrouped()) {
                parentTable = saj.getAttr("STANDALONE_TABLE_NAME");
                if (parentTable == null || parentTable.isEmpty()) {
                    parentTable = "StandAloneJobs";
                }
            } else {
                parentTable = saj.getParentName();
                if (saj.getParentName() == null || saj.getParentName().isEmpty()) {
                    parentTable = saj.getTableName();
                }
            }
            String tableID = parentTable + "$" + userdaily;
            saMap.computeIfAbsent(tableID, k -> new ArrayList());
            ((List)saMap.get(tableID)).add(saj);
        }
        return saMap;
    }
}

