/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.ActionAggregator;
import com.bmc.ctmconvert.common.draftwriter.EntitiesCounter;
import com.bmc.ctmconvert.common.draftwriter.JobConsumer;
import com.bmc.ctmconvert.common.draftwriter.MappingTable;
import com.bmc.ctmconvert.common.draftwriter.MessageMappingInterface;
import com.bmc.ctmconvert.common.draftwriter.MessagesAggregator;
import com.bmc.ctmconvert.common.draftwriter.WarningCounter;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.transformer.sched_entities.DefaultSchedEntity;
import java.util.LinkedList;
import java.util.List;

public class DataAccumulator
implements JobConsumer {
    private BaseProgressBar progressBar;
    private float left = 50.0f;
    private LinkedList<String[]> mapValues;
    private EntitiesCounter entitiesCounter = new EntitiesCounter();
    private WarningCounter warningCounter = new WarningCounter();
    private MessagesAggregator messagesAggregator;
    private ActionAggregator actionAggregator;

    public DataAccumulator(MessageMappingInterface msgMapping) {
        this.messagesAggregator = new MessagesAggregator(msgMapping);
        this.actionAggregator = new ActionAggregator();
        this.init();
    }

    public Integer getCreatedJobsCount() {
        return this.entitiesCounter.getCreatedJobsCount();
    }

    public Integer getCreatedSubCount() {
        return this.entitiesCounter.getCreatedSubCount();
    }

    public Integer getCreatedFoldersCount() {
        return this.entitiesCounter.getCreatedFoldersCount();
    }

    public void setProgressBar(BaseProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public void init() {
        this.mapValues = new LinkedList();
    }

    public void increaseTheCreatedFolderstCount() {
        DefaultSchedEntity Dumbfolder = new DefaultSchedEntity(this, "Dumbfolder", SchedEntity.TYPE.TABLE){};
        this.entitiesCounter.update(Dumbfolder, 0);
    }

    @Override
    public void update(SchedEntity job, int serial) throws ConvertorCancelClickException {
        this.mapValues.add(MappingTable.buildMappedValues(serial, job));
        this.entitiesCounter.update(job, serial);
        this.warningCounter.update(job, serial);
        this.messagesAggregator.update(job, serial);
        this.actionAggregator.update(job, serial);
        if (this.progressBar != null) {
            if (this.progressBar.isCancelled()) {
                throw new ConvertorCancelClickException("Cancel click performed!");
            }
            this.progressBar.setLabel(String.format("Processing data... (%d) entities", serial));
            this.left = (float)((double)this.left - (double)this.left * (Math.random() / 50.0) / 100.0);
            this.progressBar.setProgressValue(50 - (int)this.left + 25);
        }
    }

    public void addGeneralMessages(List<String> msgs) {
        this.messagesAggregator.addGeneralMessages(msgs);
    }

    public void setMessageAttrHolder(IAttrHolder messageAttrHolder) {
        this.messagesAggregator.setMessageAttrHolder(messageAttrHolder);
    }

    public void appendToMessageMap(String key, int serial, String message, SchedEntity job) {
        this.messagesAggregator.appendToMessageMap(key, serial, message, job);
    }

    @Override
    public void updateReporter(Reporter reporter) {
        this.entitiesCounter.updateReporter(reporter);
        this.warningCounter.updateReporter(reporter);
        this.messagesAggregator.updateReporter(reporter);
        this.actionAggregator.updateReporter(reporter);
        reporter.freeCSVWriter();
        MappingTable.writeMappingFile(Globs.TEMP_MAPPING_FILE, this.mapValues);
    }
}

