/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.conditions;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.conditions.InCondition;
import com.bmc.ctmconvert.common.conditions.InConditionsRemover;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class InConditionUtils {
    public static List<InCondition> createInConditionList(List<Properties> inconds) throws InCondition.UnMatchPropertiesException {
        ArrayList<InCondition> conditions = new ArrayList<InCondition>();
        for (Properties conditionProperties : inconds) {
            InCondition condition = InCondition.createInCondition(conditionProperties);
            conditions.add(condition);
        }
        return conditions;
    }

    public static List<Properties> getInConditionsProperties(List<InCondition> newInconditionList) {
        if (newInconditionList == null) {
            return new ArrayList<Properties>();
        }
        return newInconditionList.stream().map(InCondition::getProperties).collect(Collectors.toList());
    }

    public static List<Properties> removeConditionsByName(List<Properties> inConditions, List<Properties> inConditionsToRemove) {
        try {
            List<InCondition> inConditionList = InConditionUtils.createInConditionList(inConditions);
            InConditionsRemover conditionsRemover = new InConditionsRemover(inConditionList);
            List<String> namesOfConditionsToRemove = inConditionsToRemove.stream().map(p -> p.getProperty("NAME")).toList();
            conditionsRemover.removeAllByName(namesOfConditionsToRemove);
            return InConditionUtils.getInConditionsProperties(conditionsRemover.getConditions());
        }
        catch (InCondition.UnMatchPropertiesException e) {
            ConversionLogger.getLogger().warning(e.getMessage());
            ExceptionHandler.writeToExceptionFile(e);
            return new ArrayList<Properties>();
        }
    }
}

