/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.calendars;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.calendars.PeriodicCalendarWhenConverter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapterFactory;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.RuleBasedCalendarsAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.writers.JacksonWriter;
import com.bmc.ctmconvert.generated.json.models.Calendar.Periodic.PeriodicCalendar;
import com.bmc.ctmconvert.generated.json.models.Calendar.Periodic.Year;
import com.bmc.ctmconvert.generated.json.models.Calendar.RegularCalendar;
import com.bmc.ctmconvert.generated.json.models.Calendar.When;
import com.bmc.ctmconvert.generated.json.models.Workspace;
import com.bmc.ctmconvert.generated.json.models.scheduling.RuleBasedCalendar;
import com.bmc.ctmconvert.io.FileUtils;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class JsonDefCalFile
implements DefCalFile {
    private final Workspace ruleBasedCalendars;
    private final Workspace regularCalendars;
    private final OutputStream ruleBasedCalendarsStream;
    private final OutputStream regularCalendarsStream;
    private final JacksonWriter jsonWriter;

    JsonDefCalFile(OutputStream ruleBasedCalendarsStream, OutputStream regularCalendarsStream) {
        this.ruleBasedCalendarsStream = ruleBasedCalendarsStream;
        this.regularCalendarsStream = regularCalendarsStream;
        this.ruleBasedCalendars = new Workspace();
        this.regularCalendars = new Workspace();
        this.jsonWriter = new JacksonWriter();
    }

    @Override
    public void close() {
        try (OutputStreamWriter rbcWriter = new OutputStreamWriter(this.ruleBasedCalendarsStream, FileUtils.getDraftCharset());
             OutputStreamWriter regularWriter = new OutputStreamWriter(this.regularCalendarsStream, FileUtils.getDraftCharset());){
            this.jsonWriter.toJson(this.ruleBasedCalendars, rbcWriter);
            this.jsonWriter.toJson(this.regularCalendars, regularWriter);
        }
        catch (IOException e) {
            throw new CalendarFileWriteException(e);
        }
    }

    @Override
    public void write(CtmCalendar cal, boolean negative) {
        Optional<CtmCalendar.CalendarData> calendarData = cal.getCalendarData(negative);
        calendarData.ifPresent(calendar -> this.regularCalendars.setAdditionalProperty(calendar.name, (Object)this.createRegularCalendar((CtmCalendar.CalendarData)calendar, negative)));
    }

    private RegularCalendar createRegularCalendar(CtmCalendar.CalendarData calendar, boolean isNegative) {
        return new RegularCalendar().withServer(this.getDataCenter(calendar)).withWhen(this.createWhen(calendar, isNegative));
    }

    private String getDataCenter(CtmCalendar.CalendarData calendar) {
        if (SettingsBooleanKeys.isSaas()) {
            return null;
        }
        return calendar.dataCenter;
    }

    private When createWhen(CtmCalendar.CalendarData calendar, boolean isNegative) {
        List years = calendar.years.stream().map(year -> new Year().withYear(String.format("%d", year.year)).withJan(JsonDefCalFile.getMonthDaysFrom(year.days, 0, isNegative)).withFeb(JsonDefCalFile.getMonthDaysFrom(year.days, 1, isNegative)).withMar(JsonDefCalFile.getMonthDaysFrom(year.days, 2, isNegative)).withApr(JsonDefCalFile.getMonthDaysFrom(year.days, 3, isNegative)).withMay(JsonDefCalFile.getMonthDaysFrom(year.days, 4, isNegative)).withJun(JsonDefCalFile.getMonthDaysFrom(year.days, 5, isNegative)).withJul(JsonDefCalFile.getMonthDaysFrom(year.days, 6, isNegative)).withAug(JsonDefCalFile.getMonthDaysFrom(year.days, 7, isNegative)).withSep(JsonDefCalFile.getMonthDaysFrom(year.days, 8, isNegative)).withOct(JsonDefCalFile.getMonthDaysFrom(year.days, 9, isNegative)).withNov(JsonDefCalFile.getMonthDaysFrom(year.days, 10, isNegative)).withDec(JsonDefCalFile.getMonthDaysFrom(year.days, 11, isNegative))).collect(Collectors.toList());
        return new When().withYears(years);
    }

    @Nullable
    private static List<String> getMonthDaysFrom(CtmCalendar.YearDays yearDays, int month, boolean isNegative) {
        List<String> byMonth = yearDays.getByMonth(month, isNegative).stream().sorted().map(String::valueOf).collect(Collectors.toList());
        return byMonth.isEmpty() ? null : byMonth;
    }

    @Override
    public void writePeriodic(List<Properties> calendarData, String dataCenterName, String calName) {
        PeriodicCalendar calendar = new PeriodicCalendar().withWhen(new PeriodicCalendarWhenConverter(calendarData).convert());
        this.regularCalendars.setAdditionalProperty(calName, (Object)calendar);
    }

    @Override
    public void writeRBC(Properties rbc) {
        RuleBasedCalendar ruleBasedCalendar = this.createRuleBasedCalendar(rbc);
        String rbcName = rbc.getProperty("NAME");
        this.ruleBasedCalendars.setAdditionalProperty(rbcName, (Object)ruleBasedCalendar);
    }

    private RuleBasedCalendar createRuleBasedCalendar(Properties rbc) {
        RuleBasedCalendarsAdapter ruleBasedCalendarsAdapter = new SchedEntityAdapterFactory().createRuleBasedCalendarsAdapter(Collections.singletonList(rbc), SchedEntity.TYPE.SMART_FOLDER, rbc.getProperty("DAYS_AND_OR"));
        return ruleBasedCalendarsAdapter.getCalendar(rbc).withType(RuleBasedCalendar.Type.CALENDAR_RULE_BASED_CALENDAR);
    }

    private static class CalendarFileWriteException
    extends RuntimeException {
        public CalendarFileWriteException(Exception exception) {
            super(exception);
        }
    }
}

