/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.LinkedHashMap;
import java.util.Map;

public class EmptyAttrHolder
implements IAttrHolder {
    private Map<String, String> m_attrName2value;
    private String defaultValue;

    public EmptyAttrHolder() {
        this(new LinkedHashMap<String, String>());
    }

    public EmptyAttrHolder(Map<String, String> attrName2Value) {
        this.m_attrName2value = attrName2Value;
        this.defaultValue = null;
    }

    @Override
    public String getAttr(String attrName) {
        if (this.m_attrName2value.containsKey(attrName)) {
            return this.m_attrName2value.get(attrName);
        }
        return this.defaultValue;
    }

    @Override
    public String getCsvHeader() {
        Object header = "";
        for (String key : this.m_attrName2value.keySet()) {
            header = (String)header + key + ",";
        }
        header = ((String)header).substring(0, ((String)header).length() - 1);
        return header;
    }

    @Override
    public Integer getAttrAsInt(String attrName) {
        return Integer.parseInt(this.m_attrName2value.get(attrName));
    }

    @Override
    public boolean isFieldExist(String field) {
        return this.m_attrName2value.containsKey(field);
    }

    @Override
    public Integer appendAttr(String attrName, String attrValue) {
        this.m_attrName2value.put(attrName, attrValue);
        return 1;
    }

    @Override
    public Integer setAttr(String attrName, String attrValue) {
        return this.appendAttr(attrName, attrValue);
    }

    public String toString() {
        return "EmptyAttrHolder [m_attrName2value=" + String.valueOf(this.m_attrName2value) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_attrName2value == null ? 0 : this.m_attrName2value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmptyAttrHolder other = (EmptyAttrHolder)obj;
        return !(this.m_attrName2value == null ? other.m_attrName2value != null : !this.m_attrName2value.equals(other.m_attrName2value));
    }

    public boolean hasAttr(String attrName) {
        return this.m_attrName2value.containsKey(attrName);
    }

    public IAttrHolder defaultToNull() {
        this.defaultValue = "NULL";
        return this;
    }
}

