/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

public class CtmPriority {
    private int minRangeValue;
    private int maxRangeValue;
    private float gapBetweenHits;
    private boolean reversePriority;
    private final float ARR_LENGTH = 1296.0f;
    private char[] arr_36 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();

    public CtmPriority(int minRangeValue, int maxRangeValue) {
        if (minRangeValue < maxRangeValue) {
            this.minRangeValue = minRangeValue;
            this.maxRangeValue = maxRangeValue;
            this.reversePriority = false;
        } else {
            this.minRangeValue = maxRangeValue;
            this.maxRangeValue = minRangeValue;
            this.reversePriority = true;
        }
        this.gapBetweenHits = 1295.0f / (float)(this.maxRangeValue - this.minRangeValue);
    }

    public String calculatePriority(int origPriority) {
        if (this.reversePriority) {
            origPriority = this.maxRangeValue - this.minRangeValue - origPriority;
        }
        if (origPriority < this.minRangeValue) {
            origPriority = this.minRangeValue;
        } else if (origPriority > this.maxRangeValue) {
            origPriority = this.maxRangeValue;
        }
        return this.convertArr2Priority(origPriority -= this.minRangeValue, (float)origPriority * this.gapBetweenHits);
    }

    private String convertArr2Priority(int origPriority, float location) {
        StringBuilder priority = new StringBuilder();
        int arrLength = this.arr_36.length;
        int pos = (int)location / arrLength;
        priority.append(this.arr_36[pos]);
        pos = (int)location % arrLength;
        priority.append(this.arr_36[pos]);
        return priority.toString();
    }
}

