/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AssistingJob
implements SchedEntity {
    private SchedEntity.TYPE m_type;
    private ArrayList<Properties> m_tags;
    private ArrayList<String> m_warnings;
    private ArrayList<Properties> m_OutConditions = new ArrayList();
    private ArrayList<Properties> m_InConditions = null;
    private ArrayList<Properties> m_onStmts = null;
    private LinkedHashMap<String, String> m_autoedits = null;
    private ArrayList<String> m_optionalAttributes = null;
    private HashMap<String, String> m_attributes;
    private boolean isChildJob = false;
    private List<Properties> controlResources;

    public AssistingJob() {
        this.m_warnings = new ArrayList();
        this.m_attributes = new HashMap();
        this.controlResources = new ArrayList<Properties>();
    }

    public AssistingJob(SchedEntity.TYPE type) {
        this();
        this.m_type = type;
    }

    public AssistingJob(SchedEntity sourceJob) {
        this(SchedEntity.TYPE.JOB);
        this.setAttribute("PARENT_TABLE", sourceJob.getTableName());
        this.setAttribute("OWNER", sourceJob.getAttr("OWNER"));
        this.setAttribute("NODEID", sourceJob.getAttr("NODEID"));
        this.setAttribute("APPLICATION", sourceJob.getApplication());
        this.setAttribute("AUTHOR", sourceJob.getAttr("AUTHOR"));
        this.setAttribute("GROUP", sourceJob.getAttr("GROUP"));
        this.setAttribute("DESCRIPTION", "Assisting job created for " + sourceJob.getJobName());
        this.setAttribute("TIMEFROM", sourceJob.getAttr("TIMEFROM"));
        this.setAttribute("TIMETO", sourceJob.getAttr("TIMETO"));
        this.setAttribute("TABLE_NAME", sourceJob.getTableName());
        String priority = sourceJob.getAttr("PRIORITY");
        this.setAttribute("PRIORITY", priority == null ? "AA" : priority);
        this.setAttribute("TAG_RELATIONSHIP", sourceJob.getAttr("TAG_RELATIONSHIP"));
        this.m_tags = (ArrayList)sourceJob.getTags();
    }

    public AssistingJob copy() {
        AssistingJob assistingJob = new AssistingJob();
        assistingJob.m_type = this.m_type;
        assistingJob.m_tags = this.m_tags;
        assistingJob.m_warnings = this.m_warnings;
        assistingJob.m_OutConditions = this.m_OutConditions != null ? this.getCopy(this.m_OutConditions) : this.m_OutConditions;
        assistingJob.m_InConditions = this.m_InConditions != null ? this.getCopy(this.m_InConditions) : this.m_InConditions;
        assistingJob.m_onStmts = this.m_onStmts != null ? this.getCopy(this.m_onStmts) : this.m_onStmts;
        assistingJob.m_autoedits = this.m_autoedits;
        assistingJob.m_optionalAttributes = this.m_optionalAttributes;
        assistingJob.m_attributes = this.m_attributes;
        assistingJob.isChildJob = this.isChildJob;
        return assistingJob;
    }

    public ArrayList<Properties> getCopy(ArrayList<Properties> original) {
        ArrayList<Properties> copy = new ArrayList<Properties>();
        for (Properties p : original) {
            copy.add((Properties)p.clone());
        }
        return copy;
    }

    @Override
    public String getAttr(String attrName) {
        return this.m_attributes.get(attrName);
    }

    @Override
    public List<SchedEntity> getChildren() {
        return null;
    }

    @Override
    public List<Properties> getInConds() {
        return this.m_InConditions;
    }

    @Override
    public List<Properties> getOutConds() {
        return this.m_OutConditions;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String originalProductID() {
        return null;
    }

    @Override
    public SchedEntity.TYPE type() {
        return this.m_type;
    }

    public boolean isChildAssistingJob() {
        return this.isChildJob();
    }

    public boolean isSiblingAssistingJob() {
        return !this.isChildJob();
    }

    public void setAsChildAssistingJob(SchedEntity.TYPE parentType) {
        if (parentType == SchedEntity.TYPE.JOB) {
            ConversionLogger.getLogger().severe("Job cannot have child assisting job");
        }
        this.setChildJob(true);
    }

    public void addOutCondition(Properties outCondition) {
        this.m_OutConditions.add(outCondition);
    }

    public AssistingJob addInCondition(Properties inCondition) {
        if (this.m_InConditions == null) {
            this.m_InConditions = new ArrayList();
        }
        this.m_InConditions.add(inCondition);
        return this;
    }

    @Override
    public List<Properties> getOnStmt() {
        return this.m_onStmts;
    }

    @Override
    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public void addOnStmt(Properties stmt) {
        if (this.m_onStmts == null) {
            this.m_onStmts = new ArrayList();
        }
        this.m_onStmts.add(stmt);
    }

    @Override
    public String getJobName() {
        return this.m_attributes.get("JOBNAME");
    }

    public void setJobName(String jobName) {
        this.setAttribute("JOBNAME", jobName);
    }

    @Override
    public String getTableName() {
        return this.m_attributes.get("TABLE_NAME");
    }

    @Override
    public boolean isCyclic() {
        return this.getAttr("CYCLIC") != null && this.getAttr("CYCLIC").equals("1");
    }

    @Override
    public List<Properties> getTags() {
        return this.m_tags;
    }

    public void setM_tags(List<Properties> mTags) {
        this.m_tags = (ArrayList)mTags;
    }

    @Override
    public String applyFieldConversion(String field) {
        return null;
    }

    @Override
    public String getParentName() {
        return this.m_attributes.get("PARENT_TABLE");
    }

    @Override
    public SchedEntity getParent() {
        return null;
    }

    @Override
    public String getTablePathForSons() {
        return null;
    }

    @Override
    public List<AssistingJob> getAssistingJobs() {
        return null;
    }

    @Override
    public String getApplication() {
        return this.m_attributes.get("APPLICATION");
    }

    @Override
    public List<Properties> getCtrlResources() {
        return this.controlResources;
    }

    public AssistingJob addControlResource(Properties controlResource) {
        this.controlResources.add(controlResource);
        return this;
    }

    @Override
    public String getGroup() {
        return this.m_attributes.get("GROUP");
    }

    @Override
    public List<Properties> getQuantResources() {
        return null;
    }

    @Override
    public boolean hasWarnings() {
        return false;
    }

    @Override
    public LinkedHashMap<String, String> getAutoedits() {
        return this.m_autoedits;
    }

    @Override
    public String getOriginalJobName() {
        return "NEW_ASSISTING_JOB";
    }

    @Override
    public List<Properties> getShouts() {
        return null;
    }

    @Override
    public List<String> getOptionalAttributes() {
        return this.m_optionalAttributes;
    }

    public void setOptionalAttribute(String attribute, String value) {
        if (this.m_optionalAttributes == null) {
            this.m_optionalAttributes = new ArrayList();
        }
        if (!this.m_optionalAttributes.contains(attribute)) {
            this.m_optionalAttributes.add(attribute);
        }
        this.m_attributes.put(attribute, value);
    }

    public AssistingJob setAttribute(String attribute, String value) {
        this.addAttribute(attribute, value);
        return this;
    }

    @Override
    public void addAttribute(String attribute, String value) {
        this.m_attributes.put(attribute, value);
    }

    @Override
    public ArrayList<String> getMessages() {
        return this.m_warnings;
    }

    @Override
    public String generateUniqueID() {
        return this.getJobName();
    }

    @Override
    public boolean hasMessages() {
        return false;
    }

    public void setAutoedit(String name, String value) {
        this.initAutoedits();
        this.m_autoedits.put(name, value);
    }

    @Override
    public void addAutoEdits(String name, String value) {
        this.initAutoedits();
        this.m_autoedits.put(name, value);
    }

    private void initAutoedits() {
        if (this.m_autoedits == null) {
            this.m_autoedits = new LinkedHashMap();
        }
    }

    public void addAllAutoedits(Map<String, String> autoedits) {
        this.initAutoedits();
        this.m_autoedits.putAll(autoedits);
    }

    @Override
    public boolean isDSJob() {
        return true;
    }

    public SchedEntity toSchedEntity() {
        return this;
    }

    public boolean isChildJob() {
        return this.isChildJob;
    }

    public void setChildJob(boolean childJob) {
        this.isChildJob = childJob;
    }
}

