/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.File;
import java.util.LinkedHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AssessmentXMLDescriptionReader {
    public static final String TAG_NAME = "NAME";
    public static final String TAG_DESC = "DESC";
    public static final String TAG_VENDOR = "Vendor";
    public static final String TAG_DESCRIPTION_NODE = "DescriptionNode";
    public static final String NAME_MAIN_SUMMARY = "MainSummary";
    public static final String NAME_EXTRA_SUMMARY = "ExtraSummary";
    public static final String ATTRIBUTE_NAME = "Name";
    public static final String ATTRIBUTE_AUTO_BUILD = "AutoBuildMainSummary";
    private final LinkedHashMap<String, String> m_NodeName_NodeDescription = new LinkedHashMap();
    private boolean m_bAutoBuildMainSummary = false;

    public AssessmentXMLDescriptionReader(String fileName, String vendorName) {
        this.LoadXMLContent(fileName, vendorName);
    }

    public String getDescriptionOfNode(String nodeName) {
        return this.m_NodeName_NodeDescription.get(nodeName);
    }

    public boolean isAutoBuildMainSummary() {
        return this.m_bAutoBuildMainSummary;
    }

    public LinkedHashMap<String, String> getNodeNameNodeDescriptionMap() {
        return this.m_NodeName_NodeDescription;
    }

    public void LoadXMLContent(String fileName, String vendorName) {
        try {
            File file = new File(fileName);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            String sTempVendorName = "";
            NodeList vendorsList = doc.getElementsByTagName(TAG_VENDOR);
            for (int i = 0; i < vendorsList.getLength(); ++i) {
                Element tempVendorNode = (Element)vendorsList.item(i);
                sTempVendorName = tempVendorNode.getAttribute(ATTRIBUTE_NAME);
                if (0 != vendorName.compareToIgnoreCase(sTempVendorName)) continue;
                String sAutoBuildMainSummary = tempVendorNode.getAttribute(ATTRIBUTE_AUTO_BUILD);
                if (sAutoBuildMainSummary.compareToIgnoreCase("YES") == 0 || sAutoBuildMainSummary.compareToIgnoreCase("Y") == 0 || sAutoBuildMainSummary.compareToIgnoreCase("TRUE") == 0) {
                    this.m_bAutoBuildMainSummary = true;
                }
                String nodeName = "";
                String nodeDescription = "";
                NodeList nodesListOfVendor = tempVendorNode.getElementsByTagName(TAG_DESCRIPTION_NODE);
                for (int j = 0; j < nodesListOfVendor.getLength(); ++j) {
                    Element elmnt;
                    int x;
                    Element elmntDescriptionNode = (Element)nodesListOfVendor.item(j);
                    NodeList nodesList = elmntDescriptionNode.getElementsByTagName(TAG_NAME);
                    for (x = 0; x < nodesList.getLength(); ++x) {
                        elmnt = (Element)nodesList.item(x);
                        nodeName = elmnt.getTextContent();
                    }
                    nodesList = elmntDescriptionNode.getElementsByTagName(TAG_DESC);
                    for (x = 0; x < nodesList.getLength(); ++x) {
                        elmnt = (Element)nodesList.item(x);
                        nodeDescription = elmnt.getTextContent();
                    }
                    this.m_NodeName_NodeDescription.put(nodeName, nodeDescription);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }
}

