/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.list;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseScrollPane;
import com.bmc.ctmconvert.base.list.BaseItem;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BaseList
extends BaseComponent
implements FocusListener {
    public static final String DISPLAY_BY = "DISPLAY_BY";
    public static final String GROUP_BY = "GROUP_BY";
    public static final String SORT_BY = "SORT_BY";
    private final String GROUP_TITLE = "GroupTitle";
    protected JPanel mainContainer;
    protected JPanel listContainer;
    protected BaseScrollPane listScrollPane;
    protected List<Properties> data;
    protected Properties settings = new Properties();
    protected boolean enabled = true;
    private Border border;
    private boolean firstTime = true;
    protected BaseItem selected;
    protected ArrayList<BaseItem> itemsList;
    private HashMap<String, Integer> groupByCounters = new HashMap();
    private HashMap<String, GroupTitle> groupByTitle = new HashMap();
    private MouseAdapter selectiveListner;
    private boolean isSelectedEnabled;

    public BaseList() {
        this.data = new ArrayList<Properties>();
        this.initialize();
    }

    public BaseList(List<Properties> data, BaseFieldValidator validator) {
        this.data = data;
        this.validator = validator;
        this.initialize();
    }

    public BaseList(List<Properties> data, Properties settings, BaseFieldValidator validator) {
        this.data = data;
        this.settings = settings;
        this.validator = validator;
        this.initialize();
    }

    protected void initialize() {
        this.isSelectedEnabled = true;
        this.mainContainer = new JPanel();
        this.mainContainer.setFocusable(true);
        this.mainContainer.setRequestFocusEnabled(true);
        this.mainContainer.setLayout(new BorderLayout());
        this.mainContainer.setBorder(FlowGlobals.fieldDefaultBorder);
        this.mainContainer.addFocusListener(this);
        this.mainContainer.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10 && BaseList.this.selected != null) {
                    MouseEvent mouseEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), 0, 0, 0, 0, 2, false, 1);
                    for (MouseListener listener : BaseList.this.selected.getComponent().getMouseListeners()) {
                        listener.mouseClicked(mouseEvent);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && BaseList.this.selected != null) {
                    MouseEvent mouseEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), 0, 0, 0, 0, 2, false, 1);
                    for (MouseListener listener : BaseList.this.selected.getComponent().getMouseListeners()) {
                        listener.mouseReleased(mouseEvent);
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                block9: {
                    block10: {
                        int selectedIndex;
                        MouseEvent ev;
                        block8: {
                            int selectedIndex2;
                            ev = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), 0, 0, 0, 0, 1, false, 1);
                            if (e.getKeyCode() != 40) break block8;
                            int n = selectedIndex2 = BaseList.this.selected != null ? GlobalFunctions.getComponentIndex(BaseList.this.selected.getComponent()) : 0;
                            if (selectedIndex2 >= BaseList.this.listContainer.getComponentCount() - 1) break block9;
                            Component comp = null;
                            while ((comp = BaseList.this.listContainer.getComponent(++selectedIndex2)).getName() != null && comp.getName().equals("GroupTitle") && selectedIndex2 < BaseList.this.listContainer.getComponentCount() - 1) {
                            }
                            if (comp != null) {
                                for (MouseListener listener : comp.getMouseListeners()) {
                                    listener.mousePressed(ev);
                                }
                            }
                            break block9;
                        }
                        if (e.getKeyCode() != 38) break block10;
                        int n = selectedIndex = BaseList.this.selected != null ? GlobalFunctions.getComponentIndex(BaseList.this.selected.getComponent()) : 0;
                        if (selectedIndex <= 0) break block9;
                        Component comp = null;
                        while ((comp = BaseList.this.listContainer.getComponent(--selectedIndex)).getName() != null && comp.getName().equals("GroupTitle") && selectedIndex > 0) {
                        }
                        if (comp != null) {
                            for (MouseListener listener : comp.getMouseListeners()) {
                                listener.mousePressed(ev);
                            }
                        }
                        break block9;
                    }
                    if (e.getKeyCode() == 10 && BaseList.this.selected != null) {
                        MouseEvent mouseEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), 0, 0, 0, 0, 2, false, 1);
                        for (MouseListener listener : BaseList.this.selected.getComponent().getMouseListeners()) {
                            listener.mousePressed(mouseEvent);
                        }
                    }
                }
            }
        });
        this.listContainer = new JPanel();
        this.listContainer.setLayout(new BoxLayout(this.listContainer, 1));
        this.listScrollPane = new BaseScrollPane(this.listContainer);
        this.mainContainer.add((Component)this.listScrollPane.getComponent(), "Center");
        this.validityMessageImage = new JLabel(FlowGlobals.FIELD_VALIDATION_ERROR_ICON);
        this.validityMessageImage.setVisible(false);
        this.generateList();
    }

    public Properties getSelectedItemProperties() {
        return this.selected != null ? this.selected.getData() : null;
    }

    private void generateList() {
        this.listContainer.removeAll();
        this.listContainer.validate();
        this.itemsList = new ArrayList();
        String sortBy = this.settings.getProperty(SORT_BY, "");
        if (sortBy != null && !sortBy.isEmpty()) {
            Collections.sort(this.data, new PropertiesComparator(this, sortBy));
        }
        String groupBy = this.settings.getProperty(GROUP_BY, "");
        for (Properties prop : this.data) {
            this.addItem(groupBy, this.createItem(prop));
        }
        this.listContainer.validate();
        this.listContainer.repaint();
    }

    protected BaseItem createItem(Properties prop) {
        return new BaseItem(prop);
    }

    protected void addItem(String groupBy, BaseItem item) {
        String groupByValue = item.getData().getProperty(groupBy);
        int componentLocation = 0;
        Integer groupCounter = null;
        if (groupByValue != null && !groupByValue.isEmpty()) {
            groupCounter = this.groupByCounters.get(groupByValue);
            if (groupCounter == null) {
                if (this.groupByCounters.size() > 0) {
                    this.listContainer.add(new GroupTitle(""));
                }
                GroupTitle groupTitle = new GroupTitle(groupByValue);
                this.listContainer.add(groupTitle);
                groupCounter = new Integer(0);
                this.groupByTitle.put(groupByValue, groupTitle);
            }
            groupCounter = groupCounter + 1;
            this.groupByCounters.put(groupByValue, groupCounter);
            componentLocation = GlobalFunctions.getComponentIndex(this.groupByTitle.get(groupByValue)) + groupCounter;
        } else {
            componentLocation = this.listContainer.getComponentCount();
        }
        this.setMouseListner(item);
        this.itemsList.add(item);
        this.listContainer.add(item.getComponent(), componentLocation);
    }

    protected void setMouseListner(final BaseItem item) {
        this.selectiveListner = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (BaseList.this.enabled) {
                    if (e.isControlDown() && BaseList.this.selected != null && BaseList.this.selected.equals(item)) {
                        BaseList.this.selected.setSelected(false);
                        BaseList.this.setSelectedItem(null);
                    } else {
                        if (BaseList.this.selected != null) {
                            BaseList.this.selected.setSelected(false);
                        }
                        BaseList.this.setSelectedItem(item);
                    }
                    BaseList.this.setValidityLook(BaseList.this.isValid());
                    BaseList.this.mainContainer.requestFocus();
                    BaseList.this.valueChanged();
                }
            }
        };
        item.addMouseListener(this.selectiveListner);
    }

    public void addMouseListener(MouseListener l) {
        for (BaseItem item : this.itemsList) {
            item.addMouseListener(l);
        }
    }

    public void setSelectedItem(BaseItem selectedItem) {
        if (!this.isSelectedEnabled) {
            return;
        }
        if (this.selected != null) {
            this.selected.setSelected(false);
            this.selected = null;
        }
        if (selectedItem != null) {
            for (BaseItem item : this.itemsList) {
                if (!item.equals(selectedItem)) continue;
                this.selected = selectedItem;
            }
        }
        if (this.selected != null) {
            this.selected.setSelected(true);
        }
    }

    public void setSelectedIndex(Integer index) {
        if (index != null && this.itemsList.size() > index) {
            this.setSelectedItem(this.itemsList.get(index));
        } else {
            this.setSelectedItem(null);
        }
    }

    @Override
    public List<Properties> getData() {
        return this.data;
    }

    public void setData(List<Properties> data) {
        Properties selected = this.getSelectedItemProperties();
        int selectedIndex = 0;
        this.data = data;
        this.generateList();
        if (selected != null && data != null && data.contains(selected)) {
            selectedIndex = data.indexOf(selected);
        }
        this.setSelectedIndex(selectedIndex);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.selected != null) {
            this.selected.setSelected(enabled);
        }
        this.enableComponents(this.mainContainer, enabled);
        for (BaseItem item : this.itemsList) {
            item.setEnabled(enabled);
        }
    }

    private void enableComponents(Container container, boolean enable) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            component.setEnabled(enable);
            if (!(component instanceof Container)) continue;
            this.enableComponents((Container)component, enable);
        }
    }

    @Override
    public Component getComponent() {
        return this.mainContainer;
    }

    @Override
    public void setValidityLook(boolean valid) {
        if (this.disableValidityLook) {
            return;
        }
        if (this.border == null) {
            this.mainContainer.setBorder(valid ? (this.mainContainer.hasFocus() ? FlowGlobals.fieldSelectedBorder : FlowGlobals.fieldDefaultBorder) : FlowGlobals.fieldInvalidBorder);
        }
        if (this.validator != null && this.validityMessageImage != null) {
            this.validityMessageImage.setVisible(!valid);
            this.validityMessageImage.setToolTipText(valid ? "" : this.validator.getErrorMessage());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.border == null && (this.isValid || this.firstTime)) {
            this.mainContainer.setBorder(FlowGlobals.fieldSelectedBorder);
            this.firstTime = false;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        if (this.validator != null) {
            valid = this.validator.isValid(this.selected != null ? "YES" : "NO");
        }
        this.setValid(valid);
        return valid;
    }

    public void addItem(BaseItem item) {
        this.setMouseListner(item);
        this.itemsList.add(item);
        this.listContainer.add(item.getComponent());
        this.listContainer.validate();
        this.listContainer.repaint();
    }

    public void removeItem(BaseItem item) {
        this.itemsList.remove(item);
        this.listContainer.remove(item.getComponent());
        this.mainContainer.validate();
        this.mainContainer.repaint();
    }

    public void setBorder(Border border) {
        this.border = border == null ? BorderFactory.createEmptyBorder() : border;
        this.mainContainer.setBorder(border);
    }

    public void setSelective(boolean b) {
        this.isSelectedEnabled = b;
    }

    public BaseItem getSelectedItem() {
        return this.selected;
    }

    public class PropertiesComparator
    implements Comparator<Properties> {
        String key = "";

        public PropertiesComparator(BaseList this$0, String key) {
            this.key = key;
        }

        @Override
        public int compare(Properties X, Properties Y) {
            String strX = X.getProperty(this.key).toUpperCase();
            String strY = Y.getProperty(this.key).toUpperCase();
            return this.compareContainNumber(strX, strY);
        }

        private int compareContainNumber(String s1, String s2) {
            int val2;
            int val1;
            int i;
            ArrayList<String> sa1 = this.split(s1);
            ArrayList<String> sa2 = this.split(s2);
            if (sa1.size() == 0 || sa1.size() != sa2.size()) {
                return s1.compareTo(s2);
            }
            String si1 = "";
            String si2 = "";
            for (i = 0; i < sa1.size() && (si1 = sa1.get(i)).equals(si2 = sa2.get(i)); ++i) {
            }
            if (i == sa1.size()) {
                return 0;
            }
            try {
                val1 = Integer.parseInt(si1);
                val2 = Integer.parseInt(si2);
            }
            catch (NumberFormatException e) {
                return s1.compareTo(s2);
            }
            ++i;
            while (i < sa1.size()) {
                si1 = sa1.get(i);
                if (!si1.equals(si2 = sa2.get(i))) {
                    return s1.compareTo(s2);
                }
                ++i;
            }
            return val1 < val2 ? -1 : 1;
        }

        ArrayList<String> split(String s) {
            ArrayList<String> r = new ArrayList<String>();
            Pattern splitter = Pattern.compile("(\\d+|\\D+)");
            Matcher matcher = splitter.matcher(s);
            while (matcher.find()) {
                String m = matcher.group(1);
                r.add(m);
            }
            return r;
        }
    }

    class GroupTitle
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public GroupTitle(String title) {
            this.setName("GroupTitle");
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createRigidArea(new Dimension(0, 22)));
            JLabel groupName = new JLabel(title);
            groupName.setFont(FlowGlobals.FONT_STYLE_REGULAR);
            groupName.setForeground(FlowGlobals.ConversionBlue);
            this.add(groupName);
            this.add(Box.createHorizontalGlue());
        }
    }
}

