/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.HtmlMessageDialog;
import com.bmc.ctmconvert.base.ObserverFrame;
import com.bmc.ctmconvert.base.UpdaterProcessor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class WhatsNewDialog
extends HtmlMessageDialog {
    private int maxScreenSize;
    private String link;
    private String message;
    private JPanel linkAndButtonPanel;
    private BaseButton updateButton;

    public WhatsNewDialog(String title, String message, String link, BaseMessageDialog.TYPE type, String chBMsg, boolean check) {
        super(title, message, type, chBMsg, check);
        this.setVisualSettings();
        this.maxScreenSize = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 40;
        this.message = message;
        this.link = link;
        Frame originalFrame = ObserverFrame.instance().getCurrentFrame();
        ObserverFrame.instance().setCurrentFrame(new JFrame("Whats New"));
        this.initialize(title, message, type);
        ObserverFrame.instance().setCurrentFrame(originalFrame);
        if (this.linkAndButtonPanel != null) {
            int downloadLinkWidth = this.linkAndButtonPanel.getWidth() + this.updateButton.getWidth() + 100;
            this.jDialog.setSize(downloadLinkWidth, this.jDialog.getHeight() + 30);
        }
        if (this.isDialogTooBigToSeeOkButton()) {
            this.jDialog.setSize(new Dimension(this.jDialog.getWidth(), this.maxScreenSize));
        }
    }

    private void setVisualSettings() {
        UIManager.put("Panel.background", FlowGlobals.ConversionWhite);
        UIManager.put("ScrollPane.border", BorderFactory.createEmptyBorder());
    }

    @Override
    protected void otherTypesCase(JPanel messagePanel, String message, BaseMessageDialog.TYPE type) {
        messagePanel.setLayout(new GridBagLayout());
        this.addIconLabelToMessagePanel(messagePanel, type);
        this.addUpdateLinkAndButtonToMessagePanel(messagePanel);
        this.addHtmlMessageToMessagePanel(messagePanel, message);
    }

    private void addHtmlMessageToMessagePanel(JPanel messagePanel, String message) {
        JTextComponent messageArea = this.getHtmlTextComponent(message);
        messageArea.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        messageArea.setEditable(false);
        messageArea.setBackground(FlowGlobals.ConversionWhite);
        GridBagConstraints gridBagConstraints = this.createGridConstraints(1, 1, 1, 2, 10, 1);
        messagePanel.add((Component)messageArea, gridBagConstraints);
    }

    private void addIconLabelToMessagePanel(JPanel messagePanel, BaseMessageDialog.TYPE type) {
        JLabel iconLabel = new JLabel(WhatsNewDialog.getImageIconByType(type));
        GridBagConstraints gridBagConstraints = this.createGridConstraints(0, 2, 1, 1, 10, 1);
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        messagePanel.add((Component)iconLabel, gridBagConstraints);
    }

    private void addUpdateLinkAndButtonToMessagePanel(JPanel messagePanel) {
        this.linkAndButtonPanel = new JPanel(new GridBagLayout());
        JTextComponent linkArea = this.getHtmlTextComponent(this.link);
        linkArea.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        linkArea.setEditable(false);
        linkArea.setBackground(FlowGlobals.ConversionWhite);
        this.updateButton = this.createUpdateButton();
        GridBagConstraints gridBagConstraints = this.createGridConstraints(0, 0, 1, 1, 18, 0);
        gridBagConstraints.insets = new Insets(0, 0, 0, 30);
        this.linkAndButtonPanel.add((Component)linkArea, gridBagConstraints);
        gridBagConstraints = this.createGridConstraints(1, 0, 1, 1, 14, 0);
        this.linkAndButtonPanel.add((Component)this.updateButton, gridBagConstraints);
        gridBagConstraints = this.createGridConstraints(1, 0, 1, 1, 17, 0);
        messagePanel.add((Component)this.linkAndButtonPanel, gridBagConstraints);
    }

    private GridBagConstraints createGridConstraints(int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.gridwidth = gridwidth;
        gridBagConstraints.gridheight = gridheight;
        gridBagConstraints.fill = fill;
        gridBagConstraints.anchor = anchor;
        return gridBagConstraints;
    }

    private BaseButton createUpdateButton() {
        final BaseButton updateButton = new BaseButton("Update...");
        updateButton.setFont(updateButton.getFont().deriveFont(1));
        updateButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                updateButton.setBackground(FlowGlobals.ConversionOrange);
                updateButton.setForeground(FlowGlobals.ConversionWhite);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                updateButton.setBackground(FlowGlobals.ConversionWhite);
                updateButton.setForeground(FlowGlobals.ConversionBlack);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                UpdaterProcessor updaterProcessor = new UpdaterProcessor();
                try {
                    updaterProcessor.executeUpdate();
                }
                catch (Exception e1) {
                    ExceptionHandler.writeToExceptionFile(e1);
                    BaseMessageDialog.showMessageDialog(TextManager.instance().get("ERROR_RUN_UPDATE_TITLE"), TextManager.instance().get("ERROR_RUN_UPDATE_TEXT"), BaseMessageDialog.TYPE.ERROR_MESSAGE);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        return updateButton;
    }

    private boolean isDialogTooBigToSeeOkButton() {
        return this.jDialog.getHeight() > this.maxScreenSize;
    }
}

