/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseDialog;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.common.DescriptionManager;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BaseTextArea
extends BaseComponent
implements NavegationListener,
FocusListener,
DocumentListener,
DataRetrievable {
    private final JTextArea jTextArea;
    private JTextArea jTextAreaEdit;
    private JScrollPane jScrollPane;
    private String helpTitle;
    private BaseDialog textAreaEditor;
    private boolean firstTime = true;

    public BaseTextArea() {
        this.jTextArea = new JTextArea();
        this.initialize();
    }

    public BaseTextArea(String groupName, String componentName, String text, String helpTitle) {
        this.componentGroup = groupName;
        this.componentName = componentName;
        this.jTextArea = new JTextArea(text);
        this.helpTitle = helpTitle;
        this.initialize();
    }

    public BaseTextArea(String text, BaseFieldValidator validator) {
        this.jTextArea = new JTextArea(text);
        this.validator = validator;
        this.initialize();
    }

    @Override
    public void addFocusListener(FocusListener l) {
        this.jTextArea.addFocusListener(l);
    }

    private void initialize() {
        this.jTextArea.setBorder(null);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setBackground(FlowGlobals.fieldDefaultBackground);
        this.jTextArea.getDocument().addDocumentListener(this);
        this.jScrollPane = new JScrollPane(this.jTextArea);
        this.jScrollPane.setPreferredSize(FlowGlobals.fieldAreaSize);
        this.jScrollPane.setHorizontalScrollBarPolicy(31);
        this.jScrollPane.setBorder(FlowGlobals.fieldDefaultBorder);
        this.jScrollPane.setBackground(FlowGlobals.fieldDefaultBackground);
        this.extraComponent = ButtonFactory.createButton(ButtonFactory.ButtonType.EDIT_ICON_ONLY, e -> this.viewTextAreaEditor());
        this.textAreaEditor = new BaseDialog(this.extraComponent, TextManager.instance().get("TEXT_EDITOR_DIALOG_TITLE"), new Dimension(500, 400));
        this.textAreaEditor.addNavegationListener(this);
        BasePanel basePanel = new BasePanel();
        basePanel.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.OK, ButtonFactory.ButtonType.CANCEL}));
        basePanel.addNavegationListener(this);
        BaseContentPanel contentPanel = new BaseContentPanel();
        this.jTextAreaEdit = new JTextArea();
        this.jTextAreaEdit.setLineWrap(true);
        this.jTextAreaEdit.setBackground(FlowGlobals.fieldDefaultBackground);
        this.jTextAreaEdit.setBorder(null);
        JScrollPane jScrollPaneEdit = new JScrollPane(this.jTextAreaEdit);
        jScrollPaneEdit.setHorizontalScrollBarPolicy(31);
        jScrollPaneEdit.setBackground(FlowGlobals.fieldDefaultBackground);
        jScrollPaneEdit.setBorder(null);
        contentPanel.setContentPanel(jScrollPaneEdit);
        basePanel.setContentPanel(contentPanel);
        this.textAreaEditor.setContent(basePanel);
        this.validityMessageImage = new JLabel(FlowGlobals.FIELD_VALIDATION_ERROR_ICON);
        this.validityMessageImage.setVisible(false);
    }

    private void viewTextAreaEditor() {
        this.jTextAreaEdit.setText(this.jTextArea.getText());
        this.textAreaEditor.setVisible(true);
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        if (this.validator != null) {
            valid = this.validator.isValid(this.jTextArea.getText());
        }
        this.setValid(valid);
        return valid;
    }

    public String getText() {
        return this.jTextArea.getText();
    }

    public void setText(String t) {
        this.jTextArea.setText(t);
        this.jTextArea.setLineWrap(true);
    }

    public void setEditable(boolean b) {
        this.jTextArea.setEditable(b);
        this.jTextArea.setBackground(b ? FlowGlobals.fieldDefaultBackground : FlowGlobals.fieldReadOnlyBackground);
        this.jTextAreaEdit.setEditable(b);
        this.jTextAreaEdit.setBackground(b ? FlowGlobals.fieldDefaultBackground : FlowGlobals.fieldReadOnlyBackground);
    }

    @Override
    public void navegationActionPerformed(ConversionEvent e) {
        if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_OK_STR"))) {
            this.jTextArea.setText(this.jTextAreaEdit.getText());
            this.textAreaEditor.dispose();
        } else if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_CANCEL_STR")) || e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
            this.textAreaEditor.dispose();
        } else if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"))) {
            DescriptionManager.instance().showDescriptionDialog(this.helpTitle);
        }
    }

    @Override
    public void setValidityLook(boolean valid) {
        this.jTextArea.setBorder(valid ? (this.jTextArea.hasFocus() ? FlowGlobals.fieldTextGapSelectedBorder : FlowGlobals.fieldTextGapDefaultBorder) : FlowGlobals.fieldTextGapInvalidBorder);
        if (this.validator != null) {
            this.validityMessageImage.setVisible(!valid);
            this.validityMessageImage.setToolTipText(valid ? "" : this.validator.getErrorMessage());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.validator != null) {
            this.validator.setValidConstrain(null);
        }
        if (this.isValid || this.firstTime) {
            this.jTextArea.setBorder(FlowGlobals.fieldTextGapSelectedBorder);
            this.firstTime = false;
        }
    }

    @Override
    public String getData() {
        return this.getText();
    }

    @Override
    public void setData(Object obj) {
        if (!(obj instanceof String)) {
            return;
        }
        this.setText((String)obj);
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return DataRetrievable.DataType.STRING;
    }

    @Override
    public void setActive(Boolean b) {
        this.setEditable(b);
        super.setActive(b);
    }

    @Override
    public void addValueChangedAction(Actionable action) {
        Actionable tmpAction = action;
        this.jTextArea.addCaretListener(e -> tmpAction.act());
    }

    @Override
    public void setError(Boolean b, String Message2) {
        this.setValidityLook(b == false);
        super.setError(b, Message2);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public Component getComponent() {
        return this.jScrollPane;
    }
}

