/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import java.awt.Component;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;

public class BaseSpinner
extends BaseComponent
implements TableCellRenderer {
    private JSpinner jSpinner;
    int minValue;
    int maxValue;
    int defaultValue;

    @Override
    public Component getComponent() {
        return this.jSpinner;
    }

    public BaseSpinner(String componentName, String componentGroup, int defaultValue, int minValue, int maxValue) {
        this.componentName = componentName;
        this.componentGroup = componentGroup;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.defaultValue = defaultValue;
        this.init();
    }

    private void init() {
        SpinnerNumberModel model = new SpinnerNumberModel(this.defaultValue, this.minValue, this.maxValue, 1);
        this.jSpinner = new JSpinner();
        this.jSpinner.setBackground(FlowGlobals.ConversionWhite);
        this.jSpinner.setModel(model);
    }

    @Override
    public Object getData() {
        if (!GlobalFunctions.isNumber(this.jSpinner.getValue().toString())) {
            return null;
        }
        return Integer.valueOf(this.jSpinner.getValue().toString());
    }

    @Override
    public void setData(Object newDATA) {
        if (!(newDATA instanceof String) && !(newDATA instanceof Integer)) {
            return;
        }
        if (newDATA instanceof String && GlobalFunctions.isNumber((String)newDATA)) {
            this.jSpinner.setValue(Integer.parseInt((String)newDATA));
        } else if (newDATA instanceof Integer) {
            this.jSpinner.setValue((Integer)newDATA);
        }
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return DataRetrievable.DataType.STRING;
    }

    @Override
    public void setActive(Boolean b) {
        this.jSpinner.setEnabled(b);
    }

    @Override
    public void addValueChangedAction(final Actionable action) {
        this.jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                action.act();
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return null;
    }
}

