/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BasePasswordField
extends BaseComponent
implements FocusListener,
DocumentListener {
    private JPasswordField jPasswordField = new JPasswordField();
    private boolean firstTime = true;

    public BasePasswordField() {
        this.initialize();
    }

    public BasePasswordField(BaseFieldValidator validator) {
        this.validator = validator;
        this.initialize();
    }

    private void initialize() {
        this.jPasswordField.setBorder(FlowGlobals.fieldTextGapDefaultBorder);
        this.jPasswordField.setPreferredSize(FlowGlobals.fieldSize);
        this.jPasswordField.addFocusListener(this);
        this.jPasswordField.getDocument().addDocumentListener(this);
        if (this.validator != null) {
            this.validityMessageImage = new JLabel(FlowGlobals.FIELD_VALIDATION_ERROR_ICON);
            this.validityMessageImage.setVisible(false);
        }
    }

    public String getText() {
        return new String(this.jPasswordField.getPassword());
    }

    @Override
    public Object getData() {
        return this.getText();
    }

    @Override
    public void setData(Object obj) {
        if (!(obj instanceof String)) {
            return;
        }
        this.jPasswordField.setText((String)obj);
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        if (this.validator != null) {
            valid = this.validator.isValid(new String(this.jPasswordField.getPassword()));
        }
        this.setValid(valid);
        return valid;
    }

    public void setEnabled(boolean enabled) {
        this.jPasswordField.setEnabled(enabled);
        this.jPasswordField.setBackground(enabled ? FlowGlobals.fieldDefaultBackground : FlowGlobals.fieldReadOnlyBackground);
    }

    @Override
    public void setValidityLook(boolean valid) {
        this.jPasswordField.setBorder(valid ? (this.jPasswordField.hasFocus() ? FlowGlobals.fieldTextGapSelectedBorder : FlowGlobals.fieldTextGapDefaultBorder) : FlowGlobals.fieldTextGapInvalidBorder);
        if (this.validator != null) {
            this.validityMessageImage.setVisible(!valid);
            this.validityMessageImage.setToolTipText(valid ? "" : this.validator.getErrorMessage());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.validator != null) {
            this.validator.setValidConstrain(null);
        }
        if (this.isValid || this.firstTime) {
            this.jPasswordField.setBorder(FlowGlobals.fieldTextGapSelectedBorder);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setValidityLook(this.isValid());
    }

    @Override
    public Component getComponent() {
        return this.jPasswordField;
    }
}

