/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class BaseNavigationPanel
extends BaseComponent
implements ActionListener {
    private JPanel jPanel;
    private HashMap<ButtonFactory.ButtonType, BaseButton> buttonTypeHash;
    private HashMap<String, BaseButton> buttonHash;
    private ButtonFactory.ButtonType[] buttonTypeArray;
    private ArrayList<Component> compArray;
    private ArrayList<ButtonFactory.ButtonType> validityButtonTypeArray;

    public BaseNavigationPanel(ArrayList<Component> compArray) {
        this.compArray = compArray;
        this.initialize(this.compArray);
    }

    public BaseNavigationPanel(ButtonFactory.ButtonType[] buttonTypeArray) {
        this.buttonTypeArray = buttonTypeArray;
        this.initialize(this.buttonTypeArray);
    }

    private void initialize(ButtonFactory.ButtonType[] buttonTypeArray) {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BoxLayout(this.jPanel, 0));
        this.jPanel.setBackground(FlowGlobals.wrapperBackgroundColor);
        this.jPanel.setBorder(BorderFactory.createEmptyBorder(2, 9, 1, 9));
        this.buttonTypeHash = new HashMap();
        this.validityButtonTypeArray = new ArrayList();
        this.jPanel.add(Box.createRigidArea(new Dimension(0, 48)));
        this.jPanel.add(Box.createHorizontalGlue());
        for (int i = 0; i < buttonTypeArray.length; ++i) {
            BaseButton button = ButtonFactory.createButton(buttonTypeArray[i]);
            button.addActionListener(this);
            this.buttonTypeHash.put(buttonTypeArray[i], button);
            this.jPanel.add(button);
            this.jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        }
        if (this.buttonTypeHash.containsKey((Object)ButtonFactory.ButtonType.NEXT)) {
            this.validityButtonTypeArray.add(ButtonFactory.ButtonType.NEXT);
        }
    }

    private void initialize(ArrayList<Component> compArray) {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BoxLayout(this.jPanel, 0));
        this.jPanel.setBackground(FlowGlobals.wrapperBackgroundColor);
        this.jPanel.setBorder(BorderFactory.createEmptyBorder(2, 9, 1, 9));
        this.buttonHash = new HashMap();
        if (compArray != null) {
            for (Component comp : compArray) {
                this.add(comp);
            }
        }
    }

    public void add(Component comp) {
        this.add(comp, this.jPanel.getComponentCount());
    }

    public void add(Component comp, int index) {
        this.jPanel.add(comp, index);
        if (comp.getClass().equals(BaseButton.class)) {
            BaseButton button = (BaseButton)comp;
            this.buttonHash.put(button.getActionCommand(), button);
        }
    }

    public void setEnabled(Boolean b) {
        if (this.buttonTypeHash != null) {
            for (BaseButton button : this.buttonTypeHash.values()) {
                button.setEnabled(b);
            }
        }
        if (this.buttonHash != null) {
            for (BaseButton button : this.buttonHash.values()) {
                button.setEnabled(b);
            }
        }
    }

    public void setEnabled(ButtonFactory.ButtonType type, boolean b) {
        this.buttonTypeHash.get((Object)type).setEnabled(b);
    }

    public void setEnabled(String key, Boolean b) {
        BaseButton button = this.buttonHash.get(key);
        if (button != null) {
            button.setEnabled(b);
        }
    }

    public void setVisible(Boolean b) {
        if (this.buttonTypeHash != null) {
            for (BaseButton button : this.buttonTypeHash.values()) {
                this.setVisible(button, (boolean)b);
            }
        }
        if (this.buttonHash != null) {
            for (BaseButton button : this.buttonHash.values()) {
                this.setVisible(button, (boolean)b);
            }
        }
    }

    public void setVisible(ButtonFactory.ButtonType type, boolean b) {
        this.setVisible(this.buttonTypeHash.get((Object)type), b);
    }

    public void setVisible(String key, Boolean b) {
        this.setVisible(this.buttonHash.get(key), (boolean)b);
    }

    private void setVisible(BaseButton button, boolean b) {
        if (button != null) {
            this.jPanel.getComponent(GlobalFunctions.getComponentIndex(button) + 1).setVisible(b);
            button.setVisible(b);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireNavegationEvent(e.getActionCommand());
    }

    public void addValidityType(ButtonFactory.ButtonType type) {
        this.validityButtonTypeArray.add(type);
    }

    @Override
    public void validityActionPerformed(ConversionEvent e) {
        for (ButtonFactory.ButtonType type : this.validityButtonTypeArray) {
            this.buttonTypeHash.get((Object)type).setEnabled(e.getValue());
        }
    }

    @Override
    public Component getComponent() {
        return this.jPanel;
    }
}

