/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentSection;
import com.bmc.ctmconvert.base.list.BaseItem;
import com.bmc.ctmconvert.base.list.BaseList;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class BaseDropDown
extends BaseComponent {
    private JPanel mainPanel = new JPanel();
    private JPanel EditorPanel;
    private JLabel selectedlable;
    private BaseList list;
    private BaseList buttonslist;
    private JPopupMenu listPopup;
    private ArrayList<BaseDropDownItem> items;
    private boolean isMouseInEditorPanel = false;
    private boolean isPopupClosedBecausePressedOnEditorPanel = false;
    private JLabel arrowLable;

    public BaseDropDown() {
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setFocusable(true);
        this.mainPanel.setRequestFocusEnabled(true);
        this.EditorPanel = new JPanel();
        this.EditorPanel.setLayout(new BorderLayout());
        this.arrowLable = new JLabel(FlowGlobals.DOWN_ARROW_ICON);
        this.EditorPanel.add((Component)this.arrowLable, "East");
        this.selectedlable = new JLabel();
        this.selectedlable.setHorizontalTextPosition(11);
        this.selectedlable.setIcon(FlowGlobals.CONFIGURATION_ICON);
        this.selectedlable.setPreferredSize(new Dimension(220, 20));
        this.EditorPanel.setBorder(FlowGlobals.fieldDefaultBorder);
        this.EditorPanel.add((Component)this.selectedlable, "West");
        this.EditorPanel.add(Box.createHorizontalStrut(200), "Center");
        this.EditorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!BaseDropDown.this.isActive()) {
                    return;
                }
                if (!BaseDropDown.this.isPopupClosedBecausePressedOnEditorPanel && !BaseDropDown.this.listPopup.isVisible()) {
                    BaseDropDown.this.listPopup.setLocation(BaseDropDown.this.EditorPanel.getLocationOnScreen().x, BaseDropDown.this.EditorPanel.getLocationOnScreen().y + BaseDropDown.this.EditorPanel.getHeight());
                    BaseDropDown.this.listPopup.setInvoker(BaseDropDown.this.mainPanel);
                    BaseDropDown.this.listPopup.setVisible(true);
                } else {
                    BaseDropDown.this.isPopupClosedBecausePressedOnEditorPanel = false;
                    BaseDropDown.this.listPopup.setVisible(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseDropDown.this.isMouseInEditorPanel = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BaseDropDown.this.isMouseInEditorPanel = false;
            }
        });
        this.list = new BaseList();
        this.list.setBorder(null);
        this.buttonslist = new BaseList();
        this.buttonslist.setBorder(null);
        this.listPopup = new JPopupMenu();
        this.listPopup.setLayout(new BoxLayout(this.listPopup, 1));
        this.listPopup.add(this.list.getComponent());
        this.listPopup.addSeparator();
        this.listPopup.add(this.buttonslist.getComponent());
        this.listPopup.setVisible(false);
        this.listPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                BaseDropDown.this.isPopupClosedBecausePressedOnEditorPanel = BaseDropDown.this.isMouseInEditorPanel;
                BaseDropDown.this.listPopup.setVisible(true);
            }
        });
        this.buttonslist.setSelective(false);
        GridBagConstraints labelConstriants = BaseComponentSection.createGbc(0, 0);
        labelConstriants.insets = new Insets(0, 0, 0, 0);
        labelConstriants.weightx = 1.0;
        this.mainPanel.add((Component)this.EditorPanel, labelConstriants);
        this.items = new ArrayList();
        this.list.addValueChangedAction(new Actionable(){

            @Override
            public void act() {
                BaseItem newSelectedItem = BaseDropDown.this.list.getSelectedItem();
                if (newSelectedItem instanceof BaseDropDownItem) {
                    BaseDropDown.this.setSelectedItem((BaseDropDownItem)newSelectedItem);
                }
                BaseDropDown.this.listPopup.setVisible(false);
                BaseDropDown.this.valueChanged();
            }
        });
        this.mainPanel.setPreferredSize(new Dimension(200, 24));
    }

    public void addListItem(final BaseDropDownItem item) {
        this.items.add(item);
        item.addOnSelectedAction(new Actionable(){

            @Override
            public void act() {
                item.setMouseOut();
            }
        });
        item.getComponent().setPreferredSize(new Dimension(item.getLabelSize().width + 110, FlowGlobals.fieldSize.height));
        this.list.addItem(item);
    }

    public void removeItem(BaseDropDownItem item) {
        this.items.remove(item);
        this.list.removeItem(item);
        this.listPopup.pack();
    }

    public BaseDropDownItem createListItem(String itemName, String itemTitle, String ruleDescription) {
        return new BaseDropDownItem(this, itemName, itemTitle, ruleDescription);
    }

    @Override
    public Component getComponent() {
        return this.mainPanel;
    }

    public void removeItem(String itemName) {
        for (int i = 0; i < this.items.size(); ++i) {
            BaseDropDownItem item = this.items.get(i);
            if (!item.getName().equals(itemName)) continue;
            this.removeItem(item);
        }
    }

    public void setSelectedItem(String itemName) {
        for (int i = 0; i < this.items.size(); ++i) {
            BaseDropDownItem item = this.items.get(i);
            if (!item.getName().equals(itemName)) continue;
            this.setSelectedItem(item);
        }
    }

    public void setSelectedItem(BaseDropDownItem selectedItem) {
        this.list.setSelectedItem(selectedItem);
        this.selectedlable.setText(selectedItem.getTitle());
    }

    public void addAssistItem(BaseDropDownItem assistItem) {
        this.buttonslist.addItem(assistItem);
    }

    public BaseItem.ItemComponent createItemComponent(JButton jButton) {
        return this.createListItem("", "", "").createItemComponent(jButton);
    }

    public boolean hasItem(String Name) {
        for (BaseDropDownItem listItem : this.items) {
            if (!listItem.getName().equals(Name)) continue;
            return true;
        }
        return false;
    }

    public void setViseableItemComponent(JComponent component, BaseItem.Visible visibleState) {
        for (BaseDropDownItem listItem : this.items) {
            if (!listItem.conatainComponent(component)) continue;
            listItem.setViseableItemComponent(component, visibleState);
        }
    }

    public void setTextEditor(String text) {
        this.selectedlable.setText(text);
    }

    public void setEnabled(boolean b) {
        this.setActive(b);
        this.EditorPanel.setEnabled(b);
        this.selectedlable.setEnabled(b);
        this.arrowLable.setEnabled(b);
    }

    public String getSelectedItemName() {
        BaseItem selected = this.list.getSelectedItem();
        if (selected instanceof BaseDropDownItem) {
            return ((BaseDropDownItem)selected).getName();
        }
        return null;
    }

    public class BaseDropDownItem
    extends BaseItem {
        protected String title;
        protected JLabel itemTitleLabel;

        public BaseDropDownItem(BaseDropDown this$0, String name, String itemTitle, String ruleDescription) {
            super(name);
            this.title = itemTitle;
            this.itemTitleLabel = new JLabel(itemTitle);
            this.itemTitleLabel.setMaximumSize(new Dimension(400, this.itemTitleLabel.getMaximumSize().height));
            if (this.getLabelSize().width > 250) {
                this.itemTitleLabel.setPreferredSize(new Dimension(250, this.itemTitleLabel.getPreferredSize().height));
            }
            this.itemPanel.add(this.itemTitleLabel);
            this.itemPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.itemPanel.add(Box.createHorizontalGlue());
            this.itemPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            if (ruleDescription != null && !ruleDescription.equals("")) {
                this.itemPanel.setToolTipText(ruleDescription);
            }
        }

        public Dimension getLabelSize() {
            return this.itemTitleLabel.getPreferredSize();
        }

        public String toString() {
            return super.toString() + " (" + this.title + ")";
        }

        public String getTitle() {
            return this.title;
        }

        public BaseItem.ItemComponent createItemComponent(final JButton jButton) {
            jButton.setFocusPainted(false);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setContentAreaFilled(false);
            jButton.setBorderPainted(false);
            jButton.setOpaque(false);
            BaseItem.ItemComponent ItemComponent2 = new BaseItem.ItemComponent(this){

                @Override
                public void setVisible(Boolean b) {
                    jButton.setVisible(b);
                }

                @Override
                public Component getComponent() {
                    return jButton;
                }
            };
            return ItemComponent2;
        }

        public BaseDropDownItem addItemComponent(BaseItem.ItemComponent ItemComponent2) {
            ItemComponent2.getComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    BaseDropDownItem.this.handleMouseIsOut(e);
                }
            });
            this.itemComponents.add(ItemComponent2);
            ItemComponent2.setVisible(false);
            this.itemPanel.setMinimumSize(new Dimension(this.itemPanel.getWidth() + ItemComponent2.getComponent().getWidth(), this.itemPanel.getHeight()));
            this.itemPanel.add(ItemComponent2.getComponent());
            return this;
        }

        public BaseDropDownItem addOnSelectedAction(final Actionable actionable) {
            this.addMouseListener(new MouseAdapter(this){

                @Override
                public void mousePressed(MouseEvent e) {
                    actionable.act();
                }
            });
            return this;
        }

        public boolean conatainComponent(JComponent component) {
            return this.getListItemComponentBycomponent(component) != null;
        }

        public void setViseableItemComponent(JComponent component, BaseItem.Visible visibleState) {
            BaseItem.ItemComponent itemComponent = this.getListItemComponentBycomponent(component);
            if (itemComponent != null) {
                itemComponent.setVisibleState(visibleState);
                if (visibleState == BaseItem.Visible.NEVER || !this.isMouseInListItem && visibleState == BaseItem.Visible.MOUSEOVER_ONLY) {
                    itemComponent.setVisible(false);
                }
            }
        }

        public BaseItem.ItemComponent getListItemComponentBycomponent(JComponent component) {
            for (BaseItem.ItemComponent item : this.itemComponents) {
                if (!item.getComponent().equals(component)) continue;
                return item;
            }
            return null;
        }
    }
}

