/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.io.IOException;
import java.io.PrintStream;

public class JobtracJCLtoCreateCopyMembers {
    private String m_jclName;
    private PrintStream m_outstream = null;
    private boolean m_altJclLib = false;
    private static Integer m_stepNumber = 1;
    private static String m_configPrimary = "";
    private static String m_configSecondary = "";
    private static String m_configDirBlocks = "";
    private static Integer m_extended = 0;
    private final String JCL_SPACE_FORMAT = "//         SPACE=(CYL,(&PALLOC,&SALLOC,&DALLOC)), ";
    private final String JCL_VOLSER_FORMAT = "//         VOL=SER=%s,UNIT=%s ";
    private final String JCL_SMSDC_FORMAT = "//         DATACLAS=%s, ";
    private final String JCL_SMSSC_FORMAT = "//         STORCLAS=%s, ";
    private final String JCL_SMSMC_FORMAT = "//         MGMTCLAS=%s ";
    private final String JCL_STEPNAME_FORMAT = "%s%d";
    private final String JCL_CRTJCL1_FORMAT = "//%-8.8s EXEC CREJCL,";
    private final String JCL_CRTJCL2_FORMAT = "//         DSNAME=%s,";
    private final String JCL_CRTJCL3_FORMAT = "//         PALLOC=%s,";
    private final String JCL_CRTJCL4_FORMAT = "//         SALLOC=%s,";
    private final String JCL_CRTJCL5_FORMAT = "//         DALLOC=%s";
    private final String JCL_CPYJCL1_FORMAT = "//%-8.8s EXEC COPYJCL, ";
    private final String JCL_CPYJCL2_FORMAT = "//         INDSN=%s, ";
    private final String JCL_CPYJCL3_FORMAT = "//         OUTDSN=%s ";

    public JobtracJCLtoCreateCopyMembers(String jclName, RulesDataSet m_rules) throws IOException {
        this.m_jclName = jclName;
        this.m_outstream = new PrintStream(this.m_jclName, DraftFormat.getDraftCharSet());
        m_configPrimary = m_rules.getStringRule("Mainframe", new String[]{"PRIMARYALLOCATION"});
        m_configSecondary = m_rules.getStringRule("Mainframe", new String[]{"SECONDARYALLOCATION"});
        m_configDirBlocks = m_rules.getStringRule("Mainframe", new String[]{"DIRECTORYBLOCKS"});
        if (GlobalFunctions.isNumber((String)m_configDirBlocks)) {
            m_extended = Integer.parseInt(m_configDirBlocks);
        }
        this.initJCL(m_rules);
    }

    private void initJCL(RulesDataSet m_rules) {
        String outputLine = "";
        m_stepNumber = 1;
        if (m_rules.getBooleanRule("Mainframe", new String[]{"ALTERNATE_LIBRARIES"}).booleanValue()) {
            this.m_altJclLib = true;
            outputLine = "//CREJCL   PROC";
            this.m_outstream.println(outputLine);
            outputLine = "//CREJCLS  EXEC PGM=IEFBR14";
            this.m_outstream.println(outputLine);
            outputLine = "//TEMPLIB1 DD  DISP=(NEW,CATLG),DSN=&DSNAME,";
            this.m_outstream.println(outputLine);
            outputLine = String.format("//         SPACE=(CYL,(&PALLOC,&SALLOC,&DALLOC)), ", new Object[0]);
            this.m_outstream.println(outputLine);
            outputLine = "//         DCB=(RECFM=FB,LRECL=80,DSORG=PO),";
            this.m_outstream.println(outputLine);
            String configVolser = m_rules.getStringRule("Mainframe", new String[]{"VOLSER"});
            if (!configVolser.isEmpty()) {
                String configUnit = m_rules.getStringRule("Mainframe", new String[]{"UNIT"});
                if (configUnit.isEmpty()) {
                    configUnit = "3390";
                }
                outputLine = String.format("//         VOL=SER=%s,UNIT=%s ", configVolser, configUnit);
                this.m_outstream.println(outputLine);
            } else {
                String configSmsdc = m_rules.getStringRule("Mainframe", new String[]{"SMSDATACLASS"});
                outputLine = String.format("//         DATACLAS=%s, ", configSmsdc);
                this.m_outstream.println(outputLine);
                String configSmssc = m_rules.getStringRule("Mainframe", new String[]{"SMSSTORAGECLASS"});
                outputLine = String.format("//         STORCLAS=%s, ", configSmssc);
                this.m_outstream.println(outputLine);
                String configSmsmc = m_rules.getStringRule("Mainframe", new String[]{"SMSMANAGEMENTCLASS"});
                outputLine = String.format("//         MGMTCLAS=%s ", configSmsmc);
                this.m_outstream.println(outputLine);
            }
            outputLine = "//         PEND";
            this.m_outstream.println(outputLine);
        }
        outputLine = "//COPYJCL  PROC";
        this.m_outstream.println(outputLine);
        outputLine = "//UPDTE    EXEC PGM=IEBUPDTE,PARM=NEW";
        this.m_outstream.println(outputLine);
        outputLine = "//SYSABEND  DD SYSOUT=*";
        this.m_outstream.println(outputLine);
        outputLine = "//SYSMDUMP  DD SYSOUT=*";
        this.m_outstream.println(outputLine);
        outputLine = "//SYSUDUMP  DD SYSOUT=*";
        this.m_outstream.println(outputLine);
        outputLine = "//SYSPRINT  DD SYSOUT=*";
        this.m_outstream.println(outputLine);
        outputLine = "//SYSUT1    DD DISP=OLD,DSN=&OUTDSN";
        this.m_outstream.println(outputLine);
        outputLine = "//SYSUT2    DD DISP=OLD,DSN=&OUTDSN";
        this.m_outstream.println(outputLine);
        outputLine = "//SYSIN     DD DISP=SHR,DSN=&INDSN";
        this.m_outstream.println(outputLine);
        outputLine = "//          PEND";
        this.m_outstream.println(outputLine);
    }

    public void appendJCLStep(String sourceJclLib, String targetJclLib) {
        String outputLine = "";
        String stepName = "";
        if (this.m_altJclLib) {
            outputLine = "//*";
            this.m_outstream.println(outputLine);
            stepName = String.format("%s%d", "CRE", m_stepNumber);
            outputLine = String.format("//%-8.8s EXEC CREJCL,", stepName);
            this.m_outstream.println(outputLine);
            outputLine = String.format("//         DSNAME=%s,", targetJclLib);
            this.m_outstream.println(outputLine);
            outputLine = String.format("//         PALLOC=%s,", m_configPrimary);
            this.m_outstream.println(outputLine);
            outputLine = String.format("//         SALLOC=%s,", m_configSecondary);
            this.m_outstream.println(outputLine);
            outputLine = String.format("//         DALLOC=%s", m_extended);
            this.m_outstream.println(outputLine);
        }
        outputLine = "//*";
        this.m_outstream.println(outputLine);
        stepName = String.format("%s%d", "COPY", m_stepNumber);
        Integer n = m_stepNumber;
        m_stepNumber = m_stepNumber + 1;
        outputLine = String.format("//%-8.8s EXEC COPYJCL, ", stepName);
        this.m_outstream.println(outputLine);
        outputLine = String.format("//         INDSN=%s, ", sourceJclLib);
        this.m_outstream.println(outputLine);
        outputLine = String.format("//         OUTDSN=%s ", targetJclLib);
        this.m_outstream.println(outputLine);
        outputLine = "//*";
        this.m_outstream.println(outputLine);
    }

    public void finalize_() {
        this.m_outstream.close();
    }

    public static void main(String[] args) {
        RulesDataSet m_rules = null;
        try {
            JobtracJCLtoCreateCopyMembers JCLCreator = new JobtracJCLtoCreateCopyMembers("E:\\TEMP\\Jobtrac\\JCLCRT.out", m_rules);
            JCLCreator.appendJCLStep("SOURCE1", "TARGET1");
            JCLCreator.appendJCLStep("SOURCE2", "TARGET2");
            JCLCreator.appendJCLStep("SOURCE3", "TARGET3");
            JCLCreator.appendJCLStep("SOURCE4", "TARGET4");
            JCLCreator.appendJCLStep("SOURCE5", "TARGET5");
            JCLCreator.appendJCLStep("SOURCE6", "TARGET6");
            JCLCreator.appendJCLStep("SOURCE7", "TARGET7");
            JCLCreator.appendJCLStep("SOURCE8", "TARGET8");
            JCLCreator.appendJCLStep("SOURCE9", "TARGET9");
            JCLCreator.appendJCLStep("SOURCE10", "TARGET10");
            JCLCreator.appendJCLStep("SOURCE11", "TARGET11");
            JCLCreator.appendJCLStep("SOURCE12", "TARGET12");
            JCLCreator.appendJCLStep("SOURCE13", "TARGET13");
            JCLCreator.appendJCLStep("SOURCE14", "TARGET14");
            JCLCreator.finalize_();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }
}

