/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.util.ArrayList;
import java.util.HashMap;

public class JobTracAssessmentSCLCSVReader {
    private String[] m_jobColumnsHeaders;
    private int m_rowsCount = 0;
    private int m_jobsCount = 0;
    private HashMap<String, ArrayList<String>> m_MEMBER_JobsIDList = new HashMap();
    private HashMap<String, ArrayList<String>> m_Name_JobIDsList = new HashMap();
    private HashMap<String, String> m_JobID_Name = new HashMap();
    private HashMap<String, ArrayList<String>> m_JobID_Globals = new HashMap();
    private HashMap<String, String> m_JobID_SCL = new HashMap();

    public int getJobsNumber() {
        return this.m_jobsCount;
    }

    public String[] getJobColumnsHeaders() {
        return this.m_jobColumnsHeaders;
    }

    public HashMap<String, ArrayList<String>> getJobGlobalMEMBERsVariables(String jobFullName) {
        HashMap<String, ArrayList<String>> resMap = null;
        ArrayList<String> jobIDsList = this.m_Name_JobIDsList.get(jobFullName);
        if (null != jobIDsList) {
            resMap = new HashMap<String, ArrayList<String>>();
            for (String jobID : jobIDsList) {
                resMap.put(jobID, this.m_JobID_Globals.get(jobID));
            }
        }
        return resMap;
    }

    public HashMap<String, String> getJobSCLDefinition(String jobFullName) {
        HashMap<String, String> resMap = null;
        ArrayList<String> jobIDsList = this.m_Name_JobIDsList.get(jobFullName);
        if (null != jobIDsList) {
            resMap = new HashMap<String, String>();
            for (String jobID : jobIDsList) {
                resMap.put(jobID, this.m_JobID_SCL.get(jobID));
            }
        }
        return resMap;
    }

    public int getNumberOfApperance(String fullJobName) {
        ArrayList<String> jobIDsList;
        int iNum = 0;
        if (this.m_Name_JobIDsList.containsKey(fullJobName) && null != (jobIDsList = this.m_Name_JobIDsList.get(fullJobName))) {
            iNum = jobIDsList.size();
        }
        return iNum;
    }

    public ArrayList<String> getJobsListOfMEMBER(String memberID) {
        ArrayList<String> jobsIDArr = this.m_MEMBER_JobsIDList.get(memberID);
        if (null == jobsIDArr) {
            return null;
        }
        ArrayList<String> resultArr = new ArrayList<String>();
        for (String jobID : jobsIDArr) {
            resultArr.add(this.m_JobID_Name.get(jobID));
        }
        return resultArr;
    }

    public ArrayList<String> getAllMEMBERsOfLibrary(String libraryID) {
        return new ArrayList<String>(this.m_MEMBER_JobsIDList.keySet());
    }

    public void freeData() {
        if (null != this.m_MEMBER_JobsIDList) {
            for (String key : this.m_MEMBER_JobsIDList.keySet()) {
                this.m_MEMBER_JobsIDList.get(key).clear();
            }
            this.m_MEMBER_JobsIDList.clear();
        }
        if (null != this.m_JobID_Globals) {
            for (String key : this.m_JobID_Globals.keySet()) {
                this.m_JobID_Globals.get(key).clear();
            }
            this.m_JobID_Globals.clear();
        }
        if (null != this.m_JobID_SCL) {
            this.m_JobID_SCL.clear();
        }
        if (null != this.m_JobID_Name) {
            this.m_JobID_Name.clear();
        }
        if (null != this.m_Name_JobIDsList) {
            for (String key : this.m_Name_JobIDsList.keySet()) {
                this.m_Name_JobIDsList.get(key).clear();
            }
            this.m_Name_JobIDsList.clear();
        }
    }

    public void loadSCLFile(String fileName) {
        try {
            CsvReader reader = new CsvReader(fileName);
            String sMemberName = "";
            int index_MemberName = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "SCLmember");
            Object sEventFullName = "";
            int index_EventName = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "EVENTNM");
            String sEventVersion = "";
            int index_EventVersion = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "EventVersion");
            int index_SCL = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "SCLLine");
            String sCurrentJobID = "";
            int index_JobID = JobTracGlobals.getIndexOfHeaderInCSV("SCL", "JobID");
            reader.readRecord();
            int nAttributes = JobTracGlobals.SCL_HEADERS.length;
            ArrayList<String> globalsList = null;
            ArrayList<String> jobsList = null;
            Object sSCLVal = null;
            String[] sValues = new String[nAttributes];
            ArrayList<String> jobIDsList = null;
            while (reader.readRecord()) {
                sValues = reader.getValues();
                sMemberName = sValues[index_MemberName];
                sEventFullName = sValues[index_EventName];
                sEventVersion = sValues[index_EventVersion];
                sCurrentJobID = sValues[index_JobID];
                if (!sEventVersion.isEmpty()) {
                    sEventFullName = (String)sEventFullName + " - " + sEventVersion;
                }
                this.m_JobID_Name.put(sCurrentJobID, (String)sEventFullName);
                jobIDsList = this.m_Name_JobIDsList.get(sMemberName + " - " + (String)sEventFullName);
                if (null == jobIDsList) {
                    jobIDsList = new ArrayList();
                }
                if (!jobIDsList.contains(sCurrentJobID)) {
                    jobIDsList.add(sCurrentJobID);
                }
                this.m_Name_JobIDsList.put(sMemberName + " - " + (String)sEventFullName, jobIDsList);
                jobsList = this.m_MEMBER_JobsIDList.get(sMemberName);
                if (null == jobsList) {
                    jobsList = new ArrayList();
                }
                if (!jobsList.contains(sCurrentJobID)) {
                    jobsList.add(sCurrentJobID);
                }
                this.m_MEMBER_JobsIDList.put(sMemberName, jobsList);
                sSCLVal = this.m_JobID_SCL.get(sCurrentJobID);
                if (null != sSCLVal) {
                    sSCLVal = (String)sSCLVal + JobTracGlobals.NewLine;
                    sSCLVal = (String)sSCLVal + sValues[index_SCL];
                } else {
                    sSCLVal = sValues[index_SCL];
                }
                this.m_JobID_SCL.put(sCurrentJobID, (String)sSCLVal);
                globalsList = this.m_JobID_Globals.get(sCurrentJobID);
                if (null == globalsList) {
                    globalsList = new ArrayList();
                    for (int i = index_JobID + 1; i < nAttributes; ++i) {
                        globalsList.add(sValues[i]);
                    }
                    this.m_JobID_Globals.put(sCurrentJobID, globalsList);
                }
                ++this.m_rowsCount;
            }
            this.m_jobsCount = Integer.parseInt(sCurrentJobID);
            reader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in AssessmentCSVFileReader - loadSCLFiles");
            ExceptionHandler.writeToExceptionFile((String)("File : " + fileName));
            ExceptionHandler.writeToExceptionFile((String)("Line : " + this.m_rowsCount));
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e)));
        }
    }
}

