/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.jobtrac.ConvertSCLToCSV;
import com.bmc.ctmconvert.jobtrac.JobTracAssessmentCSVDirectoryReader;
import com.bmc.ctmconvert.jobtrac.JobTracAssessmentEXCLPARMReader;
import com.bmc.ctmconvert.jobtrac.JobTracAssessmentSCLCSVReader;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import com.bmc.ctmconvert.jobtrac.SCLsTrackerOfMEMBERs;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.swing.tree.DefaultMutableTreeNode;

public class JobTracAssessmentReport
extends AbstractAssessmentReport {
    private JobTracAssessmentCSVDirectoryReader m_csvDirectoryReader;
    private JobTracAssessmentEXCLPARMReader m_EXCLPARMReader;
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private static final String m_sJobs = "Jobs";
    private static final String m_sCalendarsCYC = "Calendars - CycLic";
    private static final String m_sCalendarsHOL = "Calendars - Holiday";
    private static final String m_sLocations = "Locations";
    private static final String m_sNodes = "Nodes";
    private static final String m_sBUSGRPs = "Business Groups";
    private static final String m_sEXCLPARMs = "EXCLPARM";
    private static final String m_sTablesPrefix = " Tables";
    private static final String m_sADRs = "ADR Tables";
    private static final String m_sAMRs = "AMR Tables";
    private static final String m_sSCSs = "SCS Tables";
    private static final String m_sNA = "N\\A";
    private static final int m_LowMachinesThreshold = 25;
    private int m_iLowMachinesUse;
    private ArrayList<String> m_listNamesOflowMachinesUse;
    private int m_iNumberOfSCLs;
    private HashMap<String, String> m_NodeName_EntityCount;
    private HashMap<String, String> m_NodeName_InfluenceCount;
    private JobTracAssessmentSCLCSVReader m_csvFileReader;
    private int[] m_specialIndexList = ConvertSCLToCSV.indexGlobalListOfVariablesInMEMBER();
    private String m_openedCSVFile = "";
    private String m_lastMEMBERNode;
    private static final int m_iTooLarge = JobTracGlobals.MAX_JOBS_IN_SCL_CSV_FILE * 1;
    private static final int m_iMaxMEMBERsInSCL = 2500;
    private static final String m_sTooLarge = "Too Large";
    private static final String m_sTooLargeMessage = "This information is too large to fit in memory!";
    private static final String m_MEMBER_EVENT_Title = "MEMBERNM - EVENTNAM - VV";
    private static final String m_sLine_Tilte = "------------------------";
    private static final String m_sDuplicatedJob = "Several Jobs with the same name." + JobTracGlobals.NewLine + "Below is a list of all Jobs and information." + JobTracGlobals.NewLine + "Number of Jobs with the same name is ";
    private ArrayList<String> m_ListOfLargeSCLs;

    public JobTracAssessmentReport(String pathName, String descriptionXMLFileName, String EXCLPARMFileName) {
        super(pathName, descriptionXMLFileName, EXCLPARMFileName);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String EXCLPARMFileName) {
        File exclparmFile;
        this.m_NodeName_EntityCount = new HashMap();
        this.m_NodeName_InfluenceCount = new HashMap();
        this.m_iLowMachinesUse = 0;
        this.m_iNumberOfSCLs = 0;
        this.m_listNamesOflowMachinesUse = new ArrayList();
        this.m_ListOfLargeSCLs = new ArrayList();
        this.m_csvFileReader = new JobTracAssessmentSCLCSVReader();
        this.m_csvDirectoryReader = new JobTracAssessmentCSVDirectoryReader(pathName);
        if (!EXCLPARMFileName.isEmpty() && (exclparmFile = new File(EXCLPARMFileName)).exists()) {
            this.m_EXCLPARMReader = new JobTracAssessmentEXCLPARMReader(EXCLPARMFileName);
        }
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        ArrayList<String> entriesList;
        HashMap<String, ArrayList<String>> map;
        ArrayList<String> jobsListInCal;
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        DefaultMutableTreeNode mainJobsNode = new DefaultMutableTreeNode("Jobs(" + this.m_csvDirectoryReader.getJobsNumber() + ")");
        DefaultMutableTreeNode LibraryNode = null;
        DefaultMutableTreeNode mainCalendarsCYCNode = null;
        DefaultMutableTreeNode mainCalendarsHOLNode = null;
        DefaultMutableTreeNode mainLocationsNode = null;
        DefaultMutableTreeNode mainNODEsNode = null;
        DefaultMutableTreeNode mainBUSGRPsNode = null;
        DefaultMutableTreeNode mainEXCLPARMsNode = null;
        DefaultMutableTreeNode mainADRsNode = null;
        DefaultMutableTreeNode mainAMRsNode = null;
        DefaultMutableTreeNode mainSCSsNode = null;
        ArrayList<String> tempList = null;
        StringBuilder nodeName = new StringBuilder();
        SCLsTrackerOfMEMBERs.m_fileName = this.pathName + Globs.DIRSEP + "MEMBERs_SCL.txt";
        SCLsTrackerOfMEMBERs.loadMEMBERsFile();
        tempList = SCLsTrackerOfMEMBERs.getListOfAllSCLs();
        if (null != tempList) {
            if (tempList.size() > 0) {
                Collections.sort(tempList);
                for (String library : tempList) {
                    ArrayList<String> listOfMEMBERs = SCLsTrackerOfMEMBERs.getListOfAllMEMBERsOfSCL(library);
                    if (null == listOfMEMBERs) continue;
                    LibraryNode = new DefaultMutableTreeNode(library + "(" + listOfMEMBERs.size() + ")");
                    mainJobsNode.add(LibraryNode);
                    String sonNodeName = m_sNA;
                    if (listOfMEMBERs.size() > 0) {
                        if (listOfMEMBERs.size() > 2500) {
                            this.m_ListOfLargeSCLs.add(LibraryNode.toString());
                            sonNodeName = m_sTooLarge;
                        }
                        Collections.sort(listOfMEMBERs);
                        DefaultMutableTreeNode MEMBERNode = null;
                        for (String member : listOfMEMBERs) {
                            MEMBERNode = new DefaultMutableTreeNode(member);
                            MEMBERNode.add(new DefaultMutableTreeNode(sonNodeName));
                            LibraryNode.add(MEMBERNode);
                        }
                        continue;
                    }
                    LibraryNode.add(new DefaultMutableTreeNode(m_sNA));
                }
            }
            this.m_iNumberOfSCLs = tempList.size();
        }
        this.m_NodeName_EntityCount.put(m_sJobs, Integer.toString(this.m_csvDirectoryReader.getJobsNumber()));
        this.m_NodeName_InfluenceCount.put(m_sJobs, Integer.toString(this.m_csvDirectoryReader.getJobsNumber()));
        tempList = this.m_csvDirectoryReader.getAllCalendarsCYCList();
        if (null != tempList) {
            int iJobsInCalendars = 0;
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                jobsListInCal = null;
                mainCalendarsCYCNode = new DefaultMutableTreeNode("Calendars - CycLic(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sCalendarsCYC, Integer.toString(tempList.size()));
                for (String cal : tempList) {
                    nodeName.delete(0, nodeName.length());
                    nodeName.append(cal);
                    nodeName.append("(");
                    jobsListInCal = this.m_csvDirectoryReader.getJobsListOfCalendarCYC(cal);
                    if (null != jobsListInCal) {
                        nodeName.append(jobsListInCal.size());
                        iJobsInCalendars += jobsListInCal.size();
                    } else {
                        nodeName.append("0");
                    }
                    nodeName.append(")");
                    mainCalendarsCYCNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                }
            }
            this.m_NodeName_InfluenceCount.put(m_sCalendarsCYC, Integer.toString(iJobsInCalendars));
        }
        if (null != (tempList = this.m_csvDirectoryReader.getAllCalendarsHOLList())) {
            int iJobsInCalendars = 0;
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                jobsListInCal = null;
                mainCalendarsHOLNode = new DefaultMutableTreeNode("Calendars - Holiday(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sCalendarsHOL, Integer.toString(tempList.size()));
                for (String cal : tempList) {
                    nodeName.delete(0, nodeName.length());
                    nodeName.append(cal);
                    nodeName.append("(");
                    jobsListInCal = this.m_csvDirectoryReader.getJobsListOfCalendarHOL(cal);
                    if (null != jobsListInCal) {
                        nodeName.append(jobsListInCal.size());
                        iJobsInCalendars += jobsListInCal.size();
                    } else {
                        nodeName.append("0");
                    }
                    nodeName.append(")");
                    mainCalendarsHOLNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                }
            }
            this.m_NodeName_InfluenceCount.put(m_sCalendarsHOL, Integer.toString(iJobsInCalendars));
        }
        if (null != (tempList = this.m_csvDirectoryReader.getAllLocationsList())) {
            int iJobsInLocations = 0;
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                ArrayList<String> jobsListInUser = null;
                mainLocationsNode = new DefaultMutableTreeNode("Locations(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sLocations, Integer.toString(tempList.size()));
                for (String location : tempList) {
                    nodeName.delete(0, nodeName.length());
                    nodeName.append(location);
                    nodeName.append("(");
                    jobsListInUser = this.m_csvDirectoryReader.getJobsListOfLocation(location);
                    if (null != jobsListInUser) {
                        Collections.sort(jobsListInUser);
                        nodeName.append(jobsListInUser.size());
                        iJobsInLocations += jobsListInUser.size();
                    } else {
                        nodeName.append("0");
                    }
                    nodeName.append(")");
                    mainLocationsNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                }
            }
            this.m_NodeName_InfluenceCount.put(m_sLocations, Integer.toString(iJobsInLocations));
        }
        if (null != (tempList = this.m_csvDirectoryReader.getAllNODEsList())) {
            int iJobsInNODE = 0;
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                ArrayList<String> jobsListInNODE = null;
                mainNODEsNode = new DefaultMutableTreeNode("Nodes(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sNodes, Integer.toString(tempList.size()));
                for (String node : tempList) {
                    nodeName.delete(0, nodeName.length());
                    nodeName.append(node);
                    nodeName.append("(");
                    jobsListInNODE = this.m_csvDirectoryReader.getJobsListOfNODE(node);
                    if (null != jobsListInNODE) {
                        Collections.sort(jobsListInNODE);
                        nodeName.append(jobsListInNODE.size());
                        iJobsInNODE += jobsListInNODE.size();
                        if (jobsListInNODE.size() <= 25) {
                            this.m_listNamesOflowMachinesUse.add(node);
                            ++this.m_iLowMachinesUse;
                        }
                    } else {
                        nodeName.append("0");
                    }
                    nodeName.append(")");
                    mainNODEsNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                }
            }
            this.m_NodeName_InfluenceCount.put(m_sNodes, Integer.toString(iJobsInNODE));
        }
        if (null != (tempList = this.m_csvDirectoryReader.getAllBUSGRPsList())) {
            int iJobsInBUSGRP = 0;
            Collections.sort(tempList);
            if (tempList.size() > 0) {
                ArrayList<String> jobsListInBUSGRP = null;
                mainBUSGRPsNode = new DefaultMutableTreeNode("Business Groups(" + tempList.size() + ")");
                this.m_NodeName_EntityCount.put(m_sBUSGRPs, Integer.toString(tempList.size()));
                for (String BUSGRP : tempList) {
                    nodeName.delete(0, nodeName.length());
                    nodeName.append(BUSGRP);
                    nodeName.append("(");
                    jobsListInBUSGRP = this.m_csvDirectoryReader.getJobsListOfBUSGRP(BUSGRP);
                    if (null != jobsListInBUSGRP) {
                        Collections.sort(jobsListInBUSGRP);
                        nodeName.append(jobsListInBUSGRP.size());
                        iJobsInBUSGRP += jobsListInBUSGRP.size();
                    } else {
                        nodeName.append("0");
                    }
                    nodeName.append(")");
                    mainBUSGRPsNode.add(new DefaultMutableTreeNode(nodeName.toString()));
                }
            }
            this.m_NodeName_InfluenceCount.put(m_sBUSGRPs, Integer.toString(iJobsInBUSGRP));
        }
        if (null != this.m_EXCLPARMReader && null != (tempList = this.m_EXCLPARMReader.getAllEntriesNames())) {
            if (tempList.size() > 0) {
                Collections.sort(tempList);
                mainEXCLPARMsNode = new DefaultMutableTreeNode("EXCLPARM(" + tempList.size() + ")");
                for (String entry : tempList) {
                    mainEXCLPARMsNode.add(new DefaultMutableTreeNode(entry));
                }
            }
            this.m_NodeName_EntityCount.put(m_sEXCLPARMs, Integer.toString(tempList.size()));
        }
        if (null != (tempList = this.m_csvDirectoryReader.getTablesListOfType("ADR"))) {
            if (tempList.size() > 0) {
                Collections.sort(tempList);
                mainADRsNode = new DefaultMutableTreeNode("ADR Tables(" + tempList.size() + ")");
                map = null;
                DefaultMutableTreeNode ADRTableNode = null;
                for (String mapName : tempList) {
                    map = this.m_csvDirectoryReader.getTableContent("ADR", mapName);
                    if (null == map) continue;
                    ADRTableNode = new DefaultMutableTreeNode(mapName + "(" + map.keySet().size() + ")");
                    entriesList = new ArrayList<String>(map.keySet());
                    Collections.sort(entriesList);
                    for (String entry : entriesList) {
                        ADRTableNode.add(new DefaultMutableTreeNode(entry));
                    }
                    mainADRsNode.add(ADRTableNode);
                }
            }
            this.m_NodeName_EntityCount.put(m_sADRs, Integer.toString(tempList.size()));
        }
        if (null != (tempList = this.m_csvDirectoryReader.getTablesListOfType("AMR"))) {
            if (tempList.size() > 0) {
                Collections.sort(tempList);
                mainAMRsNode = new DefaultMutableTreeNode("AMR Tables(" + tempList.size() + ")");
                map = null;
                DefaultMutableTreeNode AMRTableNode = null;
                for (String mapName : tempList) {
                    map = this.m_csvDirectoryReader.getTableContent("AMR", mapName);
                    AMRTableNode = new DefaultMutableTreeNode(mapName + "(" + map.keySet().size() + ")");
                    entriesList = new ArrayList<String>(map.keySet());
                    Collections.sort(entriesList);
                    for (String entry : entriesList) {
                        AMRTableNode.add(new DefaultMutableTreeNode(entry));
                    }
                    mainAMRsNode.add(AMRTableNode);
                }
            }
            this.m_NodeName_EntityCount.put(m_sAMRs, Integer.toString(tempList.size()));
        }
        if (null != (tempList = this.m_csvDirectoryReader.getTablesListOfType("SCS"))) {
            if (tempList.size() > 0) {
                Collections.sort(tempList);
                mainSCSsNode = new DefaultMutableTreeNode("SCS Tables(" + tempList.size() + ")");
                map = null;
                DefaultMutableTreeNode SCSTableNode = null;
                for (String mapName : tempList) {
                    map = this.m_csvDirectoryReader.getTableContent("SCS", mapName);
                    SCSTableNode = new DefaultMutableTreeNode(mapName + "(" + map.keySet().size() + ")");
                    entriesList = new ArrayList<String>(map.keySet());
                    Collections.sort(entriesList);
                    for (String entry : entriesList) {
                        SCSTableNode.add(new DefaultMutableTreeNode(entry));
                    }
                    mainSCSsNode.add(SCSTableNode);
                }
            }
            this.m_NodeName_EntityCount.put(m_sSCSs, Integer.toString(tempList.size()));
        }
        if (null != mainJobsNode) {
            mainTreeNodes.add(mainJobsNode);
        }
        if (null != mainBUSGRPsNode) {
            mainTreeNodes.add(mainBUSGRPsNode);
        }
        if (null != mainLocationsNode) {
            mainTreeNodes.add(mainLocationsNode);
        }
        if (null != mainCalendarsCYCNode) {
            mainTreeNodes.add(mainCalendarsCYCNode);
        }
        if (null != mainCalendarsHOLNode) {
            mainTreeNodes.add(mainCalendarsHOLNode);
        }
        if (null != mainEXCLPARMsNode) {
            mainTreeNodes.add(mainEXCLPARMsNode);
        }
        if (null != mainADRsNode) {
            mainTreeNodes.add(mainADRsNode);
        }
        if (null != mainAMRsNode) {
            mainTreeNodes.add(mainAMRsNode);
        }
        if (null != mainSCSsNode) {
            mainTreeNodes.add(mainSCSsNode);
        }
        if (null != mainNODEsNode) {
            mainTreeNodes.add(mainNODEsNode);
        }
        return mainTreeNodes;
    }

    protected String getJobInfo(String messageID) {
        StringBuilder formatedData = new StringBuilder();
        String[] messagePartArray = messageID.split(";");
        if (messagePartArray.length >= 4) {
            if (messagePartArray[1].startsWith(m_sJobs)) {
                if (messagePartArray.length == 5 && messagePartArray[4].equals(m_sTooLarge)) {
                    return m_sTooLargeMessage;
                }
                if (this.m_ListOfLargeSCLs.contains(messagePartArray[2])) {
                    return "";
                }
                String sSCLFileName = this.pathName + Globs.DIRSEP + "SCL_" + messagePartArray[2].split("\\(")[0] + ".csv";
                if (!sSCLFileName.equals(this.m_openedCSVFile)) {
                    Runtime.getRuntime().gc();
                    this.m_openedCSVFile = sSCLFileName;
                    this.m_csvFileReader.freeData();
                    this.m_csvFileReader.loadSCLFile(sSCLFileName);
                }
                if (messagePartArray.length == 4 && !messageID.equals(this.m_lastMEMBERNode)) {
                    ArrayList<String> listOfEvents = this.m_csvFileReader.getJobsListOfMEMBER(messagePartArray[3]);
                    HashSet<String> set = new HashSet<String>(listOfEvents);
                    ArrayList<String> listOfEventsNoDuplicates = new ArrayList<String>(set);
                    this.replaceTreeNodeChildren(this.m_selectedNode, listOfEventsNoDuplicates);
                    this.m_lastMEMBERNode = messageID;
                } else if (messagePartArray.length == 5) {
                    String fullJobName = messagePartArray[3] + " - " + messagePartArray[4];
                    int iNumOfApperance = this.m_csvFileReader.getNumberOfApperance(fullJobName);
                    HashMap<String, String> sSCLLines = this.m_csvFileReader.getJobSCLDefinition(fullJobName);
                    HashMap<String, ArrayList<String>> sVariablesOfGlobalMEMBER = this.m_csvFileReader.getJobGlobalMEMBERsVariables(fullJobName);
                    return this.setSCLValues(sSCLLines, sVariablesOfGlobalMEMBER, iNumOfApperance);
                }
            } else if (messagePartArray[1].contains(m_sTablesPrefix)) {
                String tableName = messagePartArray[2].split("\\(")[0];
                String[] tableHeaders = null;
                HashMap<String, ArrayList<String>> mapContent = null;
                if (messagePartArray[1].startsWith(m_sADRs)) {
                    mapContent = this.m_csvDirectoryReader.getTableContent("ADR", tableName);
                    tableHeaders = JobTracGlobals.ADR_HEADERS;
                } else if (messagePartArray[1].startsWith(m_sAMRs)) {
                    mapContent = this.m_csvDirectoryReader.getTableContent("AMR", tableName);
                    tableHeaders = JobTracGlobals.AMR_HEADERS;
                } else if (messagePartArray[1].startsWith(m_sSCSs)) {
                    mapContent = this.m_csvDirectoryReader.getTableContent("SCS", tableName);
                    tableHeaders = JobTracGlobals.SCS_HEADERS;
                }
                ArrayList<String> entries = mapContent.get(messagePartArray[3]);
                int i = 0;
                for (String val : entries) {
                    formatedData.append(tableHeaders[i]);
                    formatedData.append(" : ");
                    formatedData.append(val);
                    formatedData.append(JobTracGlobals.NewLine);
                    ++i;
                }
            }
        } else if (messagePartArray.length == 3) {
            ArrayList<String> jobsList = null;
            String nodeName = messagePartArray[2].split("\\(")[0];
            if (messagePartArray[1].startsWith(m_sCalendarsCYC)) {
                jobsList = this.m_csvDirectoryReader.getJobsListOfCalendarCYC(nodeName);
            } else if (messagePartArray[1].startsWith(m_sCalendarsHOL)) {
                jobsList = this.m_csvDirectoryReader.getJobsListOfCalendarHOL(nodeName);
            } else if (messagePartArray[1].startsWith(m_sLocations)) {
                jobsList = this.m_csvDirectoryReader.getJobsListOfLocation(nodeName);
            } else if (messagePartArray[1].startsWith(m_sNodes)) {
                jobsList = this.m_csvDirectoryReader.getJobsListOfNODE(nodeName);
            } else if (messagePartArray[1].startsWith(m_sBUSGRPs)) {
                jobsList = this.m_csvDirectoryReader.getJobsListOfBUSGRP(nodeName);
            }
            if (null != jobsList) {
                if (jobsList.size() >= m_iTooLarge) {
                    jobsList.clear();
                    return m_sTooLargeMessage;
                }
                formatedData.append(m_MEMBER_EVENT_Title);
                formatedData.append(JobTracGlobals.NewLine);
                formatedData.append(m_sLine_Tilte);
                formatedData.append(JobTracGlobals.NewLine);
                for (String jobName : jobsList) {
                    formatedData.append(jobName);
                    formatedData.append(JobTracGlobals.NewLine);
                }
                return formatedData.toString();
            }
            if (messagePartArray[1].startsWith(m_sEXCLPARMs)) {
                String entryVal = this.m_EXCLPARMReader.getEntryValue(messagePartArray[2]);
                formatedData.append(entryVal);
            }
        }
        return formatedData.toString();
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(Params.instance().getDatasourceName());
        result.add(m_sJobs);
        result.add(m_sCalendarsCYC);
        result.add(m_sCalendarsHOL);
        result.add(m_sADRs);
        result.add(m_sAMRs);
        result.add(m_sSCSs);
        result.add(m_sEXCLPARMs);
        result.add(m_sLocations);
        result.add(m_sNodes);
        result.add(m_sBUSGRPs);
        result.add(m_sNA);
        return result;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected ArrayList<String> getSelectionList(String messageID) {
        return null;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return "";
    }

    protected HashMap<String, String> getDescriptionNodes() {
        String sMainSummary;
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append("Summary:");
        mainSummary.append(this.m_newline);
        mainSummary.append(this.m_newline);
        String extraSummary = null;
        for (String nodeName : descriptionMap_NodeName_NodeDesc.keySet()) {
            if (this.m_DescriptionXMLReader.isAutoBuildMainSummary() && nodeName.compareToIgnoreCase("MainSummary") != 0) {
                if (nodeName.compareToIgnoreCase("ExtraSummary") == 0) {
                    extraSummary = (String)descriptionMap_NodeName_NodeDesc.get(nodeName);
                } else if (nodeName.equalsIgnoreCase(m_sNodes)) {
                    if (null == this.m_listNamesOflowMachinesUse || this.m_listNamesOflowMachinesUse.size() <= 0) continue;
                    mainSummary.append(nodeName);
                    mainSummary.append(this.m_newline);
                    mainSummary.append(this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName)));
                    mainSummary.append(this.m_newline);
                    mainSummary.append(this.m_newline);
                } else {
                    mainSummary.append(nodeName);
                    mainSummary.append(this.m_newline);
                    mainSummary.append(this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName)));
                    mainSummary.append(this.m_newline);
                    mainSummary.append(this.m_newline);
                }
            }
            descriptionMap_NodeName_NodeDesc.put(nodeName, this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName)));
        }
        if (null != extraSummary) {
            mainSummary.append("ExtraSummary");
            mainSummary.append(this.m_newline);
            mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", extraSummary));
            mainSummary.append(this.m_newline);
            mainSummary.append(this.m_newline);
        }
        if (!this.m_DescriptionXMLReader.isAutoBuildMainSummary() && null != (sMainSummary = (String)descriptionMap_NodeName_NodeDesc.get("MainSummary"))) {
            mainSummary.append(sMainSummary);
            String sExtraSummary = (String)descriptionMap_NodeName_NodeDesc.get("ExtraSummary");
            if (null != sExtraSummary) {
                mainSummary.append(this.m_newline);
                mainSummary.append(this.m_newline);
                mainSummary.append("ExtraSummary");
                mainSummary.append(this.m_newline);
                mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", sExtraSummary));
                mainSummary.append(this.m_newline);
            }
        }
        descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return descriptionMap_NodeName_NodeDesc;
    }

    private String evaluateDescriptionParameters(String sNodeName, String sDescription) {
        if (!sDescription.contains("#")) {
            return sDescription;
        }
        sDescription = sDescription.replaceAll("#ENV_NAME#", Params.instance().getDatasourceName());
        sDescription = sDescription.replaceAll("#NUM_LOW_USED_MACHINES#", Integer.toString(this.m_iLowMachinesUse));
        String sNum = null;
        sNum = this.m_NodeName_EntityCount.get(sNodeName);
        if (null == sNum) {
            sNum = "0";
        }
        sDescription = sDescription.replaceAll("#NUM_ENTITIES#", sNum);
        sNum = this.m_NodeName_InfluenceCount.get(sNodeName);
        if (null == sNum) {
            sNum = "0";
        }
        sDescription = sDescription.replaceAll("#NUM_INFL_JOB#", sNum);
        sDescription = sDescription.replaceAll("#NUM_SCLS#", Integer.toString(this.m_iNumberOfSCLs));
        sNum = Integer.toString(SCLsTrackerOfMEMBERs.getNumberOfMEMBERsOfAllSCLs());
        if ((sDescription = sDescription.replaceAll("#NUM_MEMBERS#", sNum)).contains("#NUM_LOW_USED_MACHINES_LIST#")) {
            StringBuilder machinesList = new StringBuilder();
            for (String machine : this.m_listNamesOflowMachinesUse) {
                machinesList.append(machine);
                machinesList.append(this.m_newline);
            }
            sDescription = sDescription.replaceAll("#NUM_LOW_USED_MACHINES_LIST#", machinesList.toString());
        }
        return sDescription;
    }

    private String setSCLValues(HashMap<String, String> jobSCL, HashMap<String, ArrayList<String>> jobGlobalMEMBERValues, int iNumOfApperance) {
        StringBuilder formatedData = new StringBuilder();
        formatedData.setLength(0);
        if (iNumOfApperance > 1) {
            formatedData.append(m_sDuplicatedJob);
            formatedData.append(iNumOfApperance);
            formatedData.append(JobTracGlobals.NewLine);
        }
        formatedData.append("-----------------------------");
        formatedData.append(JobTracGlobals.NewLine);
        formatedData.append("Values read from SCL MEMBER :");
        formatedData.append(JobTracGlobals.NewLine);
        formatedData.append("********************************************************************************");
        formatedData.append(JobTracGlobals.NewLine);
        formatedData.append("*EVENTNM TIME DATE DEPS  RELEASE1RELEASE2RELEASE3RELEASE4 PROCESSP  OPDCCDELOCVV");
        formatedData.append(JobTracGlobals.NewLine);
        formatedData.append("********************************************************************************");
        formatedData.append(JobTracGlobals.NewLine);
        ArrayList<String> globalValues = null;
        for (String jobID : jobSCL.keySet()) {
            globalValues = jobGlobalMEMBERValues.get(jobID);
            if (null != globalValues) {
                int i = 0;
                Object allSCLGlobals = null;
                int len = this.m_specialIndexList.length;
                boolean bVariableOfListInSCL = false;
                for (String globalVar : globalValues) {
                    if (!globalVar.isEmpty()) {
                        for (int j = 0; j < len; ++j) {
                            if (this.m_specialIndexList[j] != i) continue;
                            bVariableOfListInSCL = true;
                            break;
                        }
                        if (!((String)(allSCLGlobals = bVariableOfListInSCL ? ConvertSCLToCSV.parseGlobalListOfVariablesInMEMBER(globalVar) : JobTracGlobals.SCL_HEADERS[ConvertSCLToCSV.getIndexOfGlobalVariableInSCLHeader(i)] + "=" + globalVar)).isEmpty()) {
                            formatedData.append((String)allSCLGlobals);
                            formatedData.append(JobTracGlobals.NewLine);
                        }
                    }
                    ++i;
                    bVariableOfListInSCL = false;
                }
            }
            formatedData.append(jobSCL.get(jobID));
            formatedData.append(JobTracGlobals.NewLine);
            formatedData.append(JobTracGlobals.NewLine);
        }
        return formatedData.toString();
    }
}

