/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jobtrac;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.jobtrac.JobTracGlobals;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ConvertJCLToCSV {
    private static final String m_sEXEC = " EXEC ";
    private static final String m_sPGM = "PGM=";
    private static final String m_sPROC = "PROC=";
    private static final String m_sPROCstmt = " PROC ";
    private static final String m_sPEND = " PEND ";
    private String m_sInFile = null;
    private String m_sOutFile = null;
    private String m_sJCLLib = null;

    protected ArrayList<String> setArrayOfColumnNames() {
        return new ArrayList<String>(Arrays.asList(JobTracGlobals.JCL_HEADERS));
    }

    public ConvertJCLToCSV(String sJCLLib, String inFile, String outFile) {
        this.m_sJCLLib = sJCLLib;
        this.m_sInFile = inFile;
        this.m_sOutFile = outFile;
    }

    public void convertData() {
        ArrayList stepsListAlreadyFound = null;
        String[] sArr = null;
        String sStepName = null;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        HashMap MEMBER_stepsList = new HashMap();
        String sMEMBERName = null;
        boolean binProc = false;
        int iLineNumber = 0;
        try {
            reader = new BufferedReader(new FileReader(this.m_sInFile));
            writer = new BufferedWriter(new FileWriter(this.m_sOutFile));
            String sLine = null;
            while ((sLine = reader.readLine()) != null) {
                ++iLineNumber;
                if (sLine.startsWith("*") || sLine.startsWith("//*")) continue;
                if (sLine.toUpperCase().startsWith("MEMBER NAME")) {
                    sArr = sLine.split("\\s+");
                    if (null == sArr || sArr.length < 2) continue;
                    sMEMBERName = sArr[2];
                    binProc = false;
                    continue;
                }
                if (sLine.startsWith("//") && sLine.toUpperCase().contains(m_sPEND) && sLine.length() > 9 && binProc) {
                    binProc = false;
                    continue;
                }
                if (binProc) continue;
                if (sLine.startsWith("//") && sLine.toUpperCase().contains(m_sPROCstmt) && sLine.length() > 9 && !binProc) {
                    binProc = true;
                    continue;
                }
                if (!sLine.startsWith("//") || !sLine.toUpperCase().contains(m_sEXEC) || sLine.length() <= 9 || null == (sArr = sLine.split("\\s+")) || null == sMEMBERName) continue;
                ArrayList<String> Steplist = new ArrayList<String>();
                if (null != sArr[0]) {
                    sStepName = sArr[0].replaceAll("//", "");
                    stepsListAlreadyFound = (ArrayList)MEMBER_stepsList.get(sMEMBERName);
                    if (null == stepsListAlreadyFound) {
                        stepsListAlreadyFound = new ArrayList();
                    }
                    Steplist.add(sStepName);
                }
                if (null != sArr[2]) {
                    String sEXECWhat = sArr[2].split(",")[0];
                    if (sEXECWhat.startsWith(m_sPGM)) {
                        Steplist.add(sEXECWhat.split("=")[1]);
                        Steplist.add("");
                    } else {
                        Steplist.add("");
                        if (sEXECWhat.startsWith(m_sPROC)) {
                            Steplist.add(sEXECWhat.split("=")[1]);
                        } else {
                            Steplist.add(sEXECWhat);
                        }
                    }
                    stepsListAlreadyFound.add(Steplist);
                }
                MEMBER_stepsList.put(sMEMBERName, stepsListAlreadyFound);
            }
            reader.close();
            for (String sHeader : JobTracGlobals.JCL_HEADERS) {
                writer.write(sHeader);
                writer.write(",");
            }
            writer.write(JobTracGlobals.NewLine);
            for (String sMEMBER : MEMBER_stepsList.keySet()) {
                stepsListAlreadyFound = (ArrayList)MEMBER_stepsList.get(sMEMBER);
                int sSTEPSEQ = 1;
                if (null == stepsListAlreadyFound) continue;
                for (ArrayList step : stepsListAlreadyFound) {
                    StringBuilder csvLine = new StringBuilder();
                    csvLine.append(this.m_sJCLLib);
                    csvLine.append(",");
                    csvLine.append(sMEMBER);
                    csvLine.append(",");
                    csvLine.append(sSTEPSEQ++);
                    csvLine.append(",");
                    for (int l = 0; l < step.size(); ++l) {
                        csvLine.append((String)step.get(l));
                        csvLine.append(",");
                    }
                    csvLine.append(",");
                    writer.write(csvLine.toString());
                    writer.write(JobTracGlobals.NewLine);
                    csvLine.setLength(0);
                }
            }
            writer.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Error in ConvertJCLToCSV - convertData");
            ExceptionHandler.writeToExceptionFile((String)("Error while reading from file : " + this.m_sInFile));
            ExceptionHandler.writeToExceptionFile((String)("OR Error while writing to file : " + this.m_sOutFile));
            ExceptionHandler.writeToExceptionFile((String)("In line number : " + iLineNumber));
            ExceptionHandler.writeToExceptionFile((String)("Exception : " + String.valueOf(e)));
        }
    }
}

