/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.jobtrac.CliImporterJobTrac;
import com.bmc.ctmconvert.jobtrac.DataImportJobtrac;
import com.bmc.ctmconvert.jobtrac.JobTracAssessmentReport;
import com.bmc.ctmconvert.jobtrac.JobtracDefs;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class AppData
implements VendorData {
    public String getName() {
        return "JOBTRAC";
    }

    public String getDisplayName() {
        return "Broadcom Jobtrac\u00ae";
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Schedulers;
    }

    public DataImportVendor getDataImport() {
        return new DataImportJobtrac();
    }

    public BasePanel getAssessmentReport(String path) {
        return new JobTracAssessmentReport(path, Globs.ASSESSMENT_REPORT_DESCRIPTION_XML, path + Globs.DIRSEP + "EXC.EXC");
    }

    public CliImporter getCLIImporter() {
        return new CliImporterJobTrac();
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) throws ConvertorCancelClickException {
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        String datasourcePath = Params.instance().getDatasourcePath();
        File dir = new File(datasourcePath);
        Map<String, InputStream> fileNameMap = this.createSclFileList(rules, datasourcePath, dir);
        JobtracDefs jobtracDef = new JobtracDefs();
        jobtracDef.convertScl(fileNameMap);
        return jobtracDef;
    }

    Map<String, InputStream> createSclFileList(RulesDataSet rules, String datasourcePath, File dir) {
        FileInputStream sclInputStream = null;
        File[] fileList = dir.listFiles();
        HashMap<String, InputStream> fileNameMap = new HashMap<String, InputStream>();
        boolean ProcSclIndipendent = rules.getBooleanRule("Jobtrac rules", new String[]{"ProcSclIndipendent"});
        if (ProcSclIndipendent) {
            for (int i = 0; i < fileList.length; ++i) {
                String currFileName = fileList[i].getName();
                if (!fileList[i].isFile() || !currFileName.startsWith("SCL") || !currFileName.endsWith(".csv")) continue;
                try {
                    sclInputStream = new FileInputStream(new File(fileList[i].toString()));
                }
                catch (IOException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                fileNameMap.put(fileList[i].toString(), sclInputStream);
            }
        } else {
            String sclFullFileName = datasourcePath + "MergedSCLs.csv";
            try {
                sclInputStream = new FileInputStream(new File(sclFullFileName));
            }
            catch (FileNotFoundException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            fileNameMap.put(sclFullFileName, sclInputStream);
        }
        return fileNameMap;
    }

    public InputStream getRulesResourceFile() {
        InputStream fileStream = AppData.class.getResourceAsStream("/rules.xml");
        return fileStream;
    }

    public boolean isZOS() {
        return true;
    }

    public Dimension getSize() {
        return new Dimension(670, 700);
    }

    public boolean shouldBeLoaded() {
        return SettingsBooleanKeys.isOnPremise();
    }

    public RBC.WEEKDAYS getFirstDayOfTheWeek() {
        String firstDayOfTheWeek;
        return switch (firstDayOfTheWeek = RuleManager.instance().getCurrentRules().getStringRule("Jobtrac rules", new String[]{"SWEEK"})) {
            case "SUN" -> RBC.WEEKDAYS.SUNDAY;
            default -> RBC.WEEKDAYS.MONDAY;
        };
    }
}

