/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.workspace.sourceDefinitions;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.TopLevelAttrHolder;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.message.GeneralMessage;
import com.bmc.ctmconvert.common.source_definition.NullSourceDefinitions;
import com.bmc.ctmconvert.convertor.Convertor;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.OrderableEntity;
import com.bmc.ctmconvert.workspace.entities.Folder;
import com.bmc.ctmconvert.workspace.schedentity.SmartFolderSchedEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GeneralSourceDefinitions
extends NullSourceDefinitions {
    private Convertor convertor;
    private IWorkspace workSpace;
    private ArrayList<GeneralMessage> generalMesssages;

    public GeneralSourceDefinitions(Convertor convertor, IWorkspace workSpace) {
        this.convertor = convertor;
        this.workSpace = workSpace;
        this.generalMesssages = new ArrayList();
    }

    @Override
    public void init() throws ConvertorCancelClickException {
        this.convertor.convert();
    }

    @Override
    public AttrHolderList getTopLevelEntities() {
        List<Folder> topLevelFolders = this.workSpace.getTopLevelFolders();
        AttrHolderList ret = new AttrHolderList();
        for (IWorkspaceEntity iWorkspaceEntity : topLevelFolders) {
            IdAttrHolder attributeHolder = new IdAttrHolder(iWorkspaceEntity);
            ret.add(attributeHolder);
        }
        return ret;
    }

    @Override
    public boolean hasChildren(String entId) {
        return true;
    }

    @Override
    public boolean isContainerEntity(IAttrHolder entAttr) {
        return entAttr instanceof IdAttrHolder;
    }

    @Override
    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        if (!table.equals("")) {
            throw new TableMustBEmptyException();
        }
        if (!(attributes instanceof IdAttrHolder)) {
            throw new WorngAttributeHolderException();
        }
        IdAttrHolder folderAttr = (IdAttrHolder)attributes;
        IWorkspaceEntity folder = folderAttr.getFolder();
        if (!(folder instanceof OrderableEntity)) {
            throw new WorngAttributeHolderException();
        }
        return new SmartFolderSchedEntity((OrderableEntity)((Object)folder));
    }

    public void addGeneralMessage(GeneralMessage message) {
        this.generalMesssages.add(message);
    }

    @Override
    public ArrayList<String> getGeneralMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        for (GeneralMessage message : this.generalMesssages) {
            Reporter.addMessage(messages, message.getMessageId(), message.getReportDisplayKey(), message.getMessageParams().toArray(new String[0]));
        }
        messages.addAll(this.convertor.generalMessages());
        return messages;
    }

    public class IdAttrHolder
    extends TopLevelAttrHolder {
        private static final long serialVersionUID = -2952334097398600184L;
        private IWorkspaceEntity folder;

        public IdAttrHolder(IWorkspaceEntity folder) {
            super(new String[0], new HashMap<String, Integer>(), "f");
            this.folder = folder;
        }

        public IWorkspaceEntity getFolder() {
            return this.folder;
        }
    }

    public class TableMustBEmptyException
    extends RuntimeException {
        private static final long serialVersionUID = -4867486046144114500L;
    }

    public class WorngAttributeHolderException
    extends RuntimeException {
        private static final long serialVersionUID = 334646479754380327L;
    }
}

