/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.services;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;

public class ConversionEntitiesService {
    private static Map<String, Properties> projects;
    private static Map<String, Map<String, Properties>> conversions;
    private static String currentProjectName;
    private static String currentConversionName;

    private static void initialize() {
        projects = new HashMap<String, Properties>();
        conversions = new HashMap<String, Map<String, Properties>>();
        List<Properties> projects = ConversionEntitiesService.getPropertiesList(Globs.DATASOURCES_DIR);
        projects.addAll(ConversionEntitiesService.getPropertiesList(Globs.DEMO_DATASOURCES_DIR));
        List<Properties> filteredProjects = ConversionEntitiesService.filterProjects(projects);
        for (Properties projectProperties : filteredProjects) {
            String projectName = projectProperties.getProperty("NAME");
            ConversionEntitiesService.registerProject(projectProperties);
            List<Properties> conversions = ConversionEntitiesService.getPropertiesList(ConversionEntitiesService.getProjectConversionsDirectory(projectName));
            for (Properties conversionProperties : conversions) {
                ConversionEntitiesService.registerConversion(projectName, conversionProperties);
            }
        }
    }

    private static List<Properties> filterProjects(List<Properties> projects) {
        return projects.stream().filter(ConversionEntitiesService::shouldLoadZOSProject).collect(Collectors.toList());
    }

    private static List<Properties> getPropertiesList(String pathname) {
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        File directory = new File(pathname);
        if (directory.exists() && directory.isDirectory()) {
            for (String name : directory.list()) {
                File propertiesFile;
                String path = pathname + Globs.DIRSEP + name;
                boolean isDirectory = Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0]);
                if (!isDirectory || !(propertiesFile = new File(path + Globs.DIRSEP + "properties.cfg")).exists()) continue;
                try (FileReader fileReader = new FileReader(propertiesFile);){
                    Properties properties = new Properties();
                    properties.load(fileReader);
                    toRet.add(properties);
                }
                catch (IOException e) {
                    ExceptionHandler.writeToExceptionFile(e);
                }
            }
        }
        return toRet;
    }

    public static void registerProject(Properties projectDetails) {
        String name = projectDetails.getProperty("NAME");
        if (name != null && !name.isEmpty()) {
            projects.put(name, projectDetails);
        }
    }

    public static void registerNewProject(Properties projectDetails) {
        ConversionEntitiesService.registerProject(projectDetails);
        ConversionEntitiesService.setCurrentProjectName(projectDetails.getProperty("NAME"));
    }

    public static Properties getProjectDetails(String projectName) {
        return projects.get(projectName);
    }

    public static Properties getCurrentProjectDetails() {
        return ConversionEntitiesService.getProjectDetails(ConversionEntitiesService.getCurrentProjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProjectDetails(String projectName) {
        OutputStreamWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            Properties details = projects.get(projectName);
            if (details != null) {
                fileWriter = new FileWriter(ConversionEntitiesService.getProjectDirectory(projectName) + Globs.DIRSEP + "properties.cfg");
                bufferedWriter = new BufferedWriter(fileWriter);
                details.store(bufferedWriter, null);
            }
        }
        catch (IOException e) {
            ConversionLogger.getLogger().severe("Unable to save project properties");
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                ConversionLogger.getLogger().severe("Unable to close project properties file when saving");
            }
        }
    }

    public static void saveCurrentProjectDetails() {
        ConversionEntitiesService.saveProjectDetails(ConversionEntitiesService.getCurrentProjectName());
    }

    public static List<Properties> getProjectsDetailsList() {
        ArrayList<Properties> projectsList = new ArrayList<Properties>();
        projectsList.addAll(projects.values());
        return projectsList;
    }

    public static List<Properties> getProjectConversionsDetails(String projectName) {
        Map<String, Properties> projectConversions = conversions.get(projectName);
        ArrayList<Properties> projectConversionsDetails = new ArrayList<Properties>();
        if (projectConversions != null) {
            projectConversionsDetails.addAll(projectConversions.values());
        }
        return projectConversionsDetails;
    }

    public static List<Properties> getCurrentProjectConversionsDetails() {
        return ConversionEntitiesService.getProjectConversionsDetails(ConversionEntitiesService.getCurrentProjectName());
    }

    public static void unregisterProject(String projectName) {
        projects.remove(projectName);
        conversions.remove(projectName);
    }

    public static void registerConversion(String projectName, Properties conversionDetails) {
        String name;
        Map<String, Properties> projectConversions = conversions.get(projectName);
        if (projectConversions == null) {
            projectConversions = new HashMap<String, Properties>();
        }
        if ((name = conversionDetails.getProperty("NAME")) != null && !name.isEmpty()) {
            projectConversions.put(name, conversionDetails);
        }
        conversions.put(projectName, projectConversions);
    }

    public static void registerNewConversion(Properties conversionDetails) {
        ConversionEntitiesService.registerConversion(ConversionEntitiesService.getCurrentProjectName(), conversionDetails);
        ConversionEntitiesService.setCurrentConversionName(conversionDetails.getProperty("NAME"));
    }

    public static Properties getConversionDetails(String projectName, String conversionName) {
        Map<String, Properties> projectConversions = conversions.get(projectName);
        return projectConversions != null ? projectConversions.get(conversionName) : null;
    }

    public static Properties getCurrentConversionDetails() {
        return ConversionEntitiesService.getConversionDetails(ConversionEntitiesService.getCurrentProjectName(), ConversionEntitiesService.getCurrentConversionName());
    }

    public static void unregisterConversion(String projectName) {
        conversions.remove(projectName);
    }

    public static void unregisterConversion(String projectName, String conversionName) {
        Map<String, Properties> projectConversions = conversions.get(projectName);
        if (projectConversions != null) {
            projectConversions.remove(conversionName);
        }
    }

    public static boolean isDemoProject(String projectName) {
        Properties properties = ConversionEntitiesService.getProjectDetails(projectName);
        return properties != null && "N".equals(properties.getProperty("WRITABLE"));
    }

    private static boolean shouldLoadZOSProject(Properties projectDetails) {
        Boolean isZOS = Optional.ofNullable(projectDetails).map(project -> "Y".equals(project.getProperty("IS_ZOS"))).orElse(false);
        return SettingsBooleanKeys.isOnPremise() || isZOS == false;
    }

    public static String getProjectDirectory(String projectName) {
        String datasourcesRoot = Globs.DATASOURCES_DIR;
        if (ConversionEntitiesService.isDemoProject(projectName)) {
            datasourcesRoot = Globs.DEMO_DATASOURCES_DIR;
        }
        return datasourcesRoot + Globs.DIRSEP + projectName + Globs.DIRSEP;
    }

    public static String getCurrentProjectDirectory() {
        return ConversionEntitiesService.getProjectDirectory(ConversionEntitiesService.getCurrentProjectName());
    }

    public static String getProjectDataDirectory(String projectName) {
        return ConversionEntitiesService.getProjectDirectory(projectName) + "data" + Globs.DIRSEP;
    }

    public static String getCurrentProjectDataDirectory() {
        return ConversionEntitiesService.getProjectDataDirectory(ConversionEntitiesService.getCurrentProjectName());
    }

    public static String getProjectDataObjectDirectory(String projectName) {
        return ConversionEntitiesService.getProjectDirectory(projectName) + "DataObject" + Globs.DIRSEP;
    }

    public static String getCurrentProjectDataObjectDirectory() {
        return ConversionEntitiesService.getProjectDataObjectDirectory(ConversionEntitiesService.getCurrentProjectName());
    }

    public static String getProjectConversionsDirectory(String projectName) {
        return ConversionEntitiesService.getProjectDirectory(projectName) + "CONVERSIONS" + Globs.DIRSEP;
    }

    public static String getCurrentProjectConversionsDirectory() {
        return ConversionEntitiesService.getProjectConversionsDirectory(ConversionEntitiesService.getCurrentProjectName());
    }

    public static String getConversionDirectory(String projectName, String conversionName) {
        return ConversionEntitiesService.getProjectConversionsDirectory(projectName) + conversionName + Globs.DIRSEP;
    }

    public static String getCurrentConversionDirectory() {
        return ConversionEntitiesService.getConversionDirectory(ConversionEntitiesService.getCurrentProjectName(), ConversionEntitiesService.getCurrentConversionName());
    }

    public static String getConversionRulesFile(String projectName, String conversionName) {
        return ConversionEntitiesService.getConversionDirectory(projectName, conversionName) + "Rules.xml";
    }

    public static String getCurrentConversionRulesFile() {
        return ConversionEntitiesService.getConversionRulesFile(ConversionEntitiesService.getCurrentProjectName(), ConversionEntitiesService.getCurrentConversionName());
    }

    public static String getConversionPostDirectory(String projectName, String conversionName) {
        return ConversionEntitiesService.getConversionDirectory(projectName, conversionName) + "POST_CONVERSION_SCRIPTS" + Globs.DIRSEP;
    }

    public static String getCurrentConversionPostDirectory() {
        return ConversionEntitiesService.getConversionPostDirectory(ConversionEntitiesService.getCurrentProjectName(), ConversionEntitiesService.getCurrentConversionName());
    }

    public static void setCurrentProjectName(String projectName) {
        currentProjectName = projectName;
    }

    public static String getCurrentProjectName() {
        return currentProjectName;
    }

    public static void setCurrentConversionName(String conversionName) {
        currentConversionName = conversionName;
    }

    public static String getCurrentConversionName() {
        return currentConversionName;
    }

    static {
        currentProjectName = "";
        currentConversionName = "";
        ConversionEntitiesService.initialize();
    }
}

