/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.sap;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.sap.StartCondition;

public class SapR3CopyWrapper {
    private final SchedEntity job;

    public SapR3CopyWrapper(SchedEntity job) {
        this.job = job;
    }

    public static SapR3CopyWrapper convertToSapJob(SchedEntity job) {
        SapR3CopyWrapper sapWarpwer = new SapR3CopyWrapper(job);
        Globs.SAP_TYPE_FORM_VERSION.forEach(job::addAttribute);
        if (!GlobalFunctions.jobHasTaskType.test(job)) {
            job.addAttribute("TASKTYPE", "Job");
        }
        job.addAutoEdits("%%SAPR3-DETECT_CHILD_TABLE", job.getOriginalJobName());
        job.addAutoEdits("%%SAPR3-JOB_COPY_TARGET_VAL", job.getOriginalJobName());
        if (!GlobalFunctions.JobHasAutoedit.test(job, "%%SAPR3-ACCOUNT")) {
            job.addAutoEdits("%%SAPR3-ACCOUNT", "DEFAULT_ACCOUNT");
        }
        job.addAutoEdits("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        job.addAutoEdits("%%SAPR3-JOB_MODE", "RUN_COPY");
        job.addAutoEdits("%%SAPR3-XBP_VERSION", "XBP20");
        job.addAutoEdits("%%SAPR3-DETECT_OPTION", "1");
        job.addAutoEdits("%%SAPR3-JOBCOUNT", "FIRST_SCHEDULED");
        job.addAutoEdits("%%SAPR3-JOB_COUNT", "FIRST_SCHEDULED");
        job.addAutoEdits("%%SAPR3-JOBLOG", "*SYSOUT");
        job.addAutoEdits("%%SAPR3-SUBMIT_ASAP", "N");
        job.addAutoEdits("%%SAPR3-START_STEP", "1");
        return sapWarpwer;
    }

    public SapR3CopyWrapper setSapJobName(String name) {
        this.job.addAutoEdits("%%SAPR3-JOBNAME", name);
        return this;
    }

    public SapR3CopyWrapper setConnectionProfile(String connectionProfile) {
        this.job.addAutoEdits("%%SAPR3-ACCOUNT", connectionProfile);
        return this;
    }

    public SapR3CopyWrapper setStartStep(String stepNumber) {
        this.job.addAutoEdits("%%SAPR3-START_STEP", stepNumber);
        return this;
    }

    public void setSpecificJob(String jobId) {
        this.job.addAutoEdits("%%SAPR3-JOB_COUNT", "Specific_Job");
        this.job.addAutoEdits("%%SAPR3-JOBCOUNT", jobId);
    }

    public SapR3CopyWrapper setStartCondition(StartCondition startCondition) {
        this.job.addAutoEdits("%%SAPR3-SUBMIT_ASAP", startCondition.toXmlValue());
        return this;
    }

    public SapR3CopyWrapper setJobWaitChild() {
        this.job.addAutoEdits("%%SAPR3-JOB_WAIT_CHILD", "Y");
        return this;
    }

    public SapR3CopyWrapper setDetectSpawnedJob() {
        this.job.addAutoEdits("%%SAPR3-DETECT_CHILD_JOBNAME", this.job.getJobName());
        this.job.addAutoEdits("%%SAPR3-DETECT_OPTION", "2");
        return this;
    }
}

