/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ondo;

import com.bmc.ctmconvert.ondo.Do;
import java.util.Optional;
import java.util.Properties;

public class DoMail
extends Do {
    private static final String DESTINATION_DELIMITER = ";";
    private String message;
    private String subject;
    private final String dest;
    private String urgency;
    private AttachSysout attachSysoutOption;
    private Optional<String> cc;

    public DoMail(String ... destination) {
        super("DOMAIL");
        this.dest = String.join((CharSequence)DESTINATION_DELIMITER, destination);
        this.urgency = "R";
        this.attachSysoutOption = AttachSysout.DEFAULT;
        this.cc = Optional.empty();
    }

    public DoMail setMessage(String message) {
        this.message = message;
        return this;
    }

    public DoMail setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public DoMail setUrgancy(String urgency) {
        this.urgency = urgency;
        return this;
    }

    public DoMail setCC(String cc) {
        this.cc = Optional.ofNullable(cc);
        return this;
    }

    public DoMail setAttachSysout(AttachSysout value) {
        this.attachSysoutOption = value;
        return this;
    }

    @Override
    protected Properties getDoProperties() {
        Properties ret = new Properties();
        ret.put("DEST", this.dest);
        ret.put("MESSAGE", this.message);
        ret.put("SUBJECT", this.subject);
        ret.put("URGENCY", this.urgency);
        ret.put("ATTACH_SYSOUT", this.attachSysoutOption.getName());
        this.cc.ifPresent(c -> ret.put("CC_DEST", c));
        return ret;
    }

    public static enum AttachSysout {
        YES("Yes"),
        NO("No"),
        DEFAULT("Default");

        private final String name;

        private AttachSysout(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

