/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport.fileimporter;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.dataimport.fileimporter.FileMonitor;
import com.bmc.ctmconvert.progress.Progressable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FIleImporter
extends Importer {
    protected ImportEntry entry;
    private final FileSystem fileSystem;
    private Path targetDirPath;

    public FIleImporter(ImportEntry entry, Path destinationPath) {
        this(entry, FileSystems.getDefault(), destinationPath);
    }

    public FIleImporter(ImportEntry entry, FileSystem fileSystem, Path targetDirPath) {
        this.entry = entry;
        this.fileSystem = fileSystem;
        this.targetDirPath = targetDirPath;
    }

    public void setEntry(ImportEntry entry) {
        this.entry = entry;
    }

    public void setTargetDirPath(Path targetDirPath) {
        this.targetDirPath = targetDirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Progressable.ProgressStatus performImport() {
        if (this.entry != null) {
            Path sourcePath = this.fileSystem.getPath(this.entry.getSourceFullName(), new String[0]);
            Path targetFilePath = this.targetDirPath.resolve(this.entry.getDestinationFileName());
            if (StringUtils.isEmpty((CharSequence)this.entry.getSourceFullName()) && this.entry.getSourceFullNames() != null && !this.entry.getSourceFullNames().isEmpty()) {
                Progressable.ProgressStatus status = this.copyFiles(this.entry.getSourceFullNames(), targetFilePath);
                if (status == Progressable.ProgressStatus.ENDED_SUCCESS) {
                    this.entry.setDestinationPath(targetFilePath.toAbsolutePath().toString());
                    this.setStatus(status);
                } else {
                    this.setStatus(this.entry.isMandatory() ? status : Progressable.ProgressStatus.ENDED_WITH_MESSAGE);
                }
                return this.getStatus();
            }
            Progressable fileMonitor = null;
            try {
                if (Files.isRegularFile(sourcePath, new LinkOption[0])) {
                    long fileSize = Files.size(sourcePath);
                    this.setProgressMax(fileSize);
                    fileMonitor = new FileMonitor(targetFilePath, this.entry.getID(), x$0 -> this.fireProgressEvent(x$0));
                    new Thread(fileMonitor).start();
                    ConversionLogger.getLogger().info(String.format("Copy file '%s' started", this.entry.getID()));
                    Files.copy(sourcePath, targetFilePath, new CopyOption[0]);
                    ConversionLogger.getLogger().info(String.format("Copy file '%s' ended", this.entry.getID()));
                    this.entry.setDestinationPath(targetFilePath.toAbsolutePath().toString());
                    this.setStatus(Progressable.ProgressStatus.ENDED_SUCCESS);
                } else {
                    this.setStatus(this.entry.isMandatory() ? Progressable.ProgressStatus.ENDED_FAILURE : Progressable.ProgressStatus.ENDED_WITH_MESSAGE);
                }
            }
            catch (IOException e) {
                this.setStatus(this.entry.isMandatory() ? Progressable.ProgressStatus.ENDED_FAILURE : Progressable.ProgressStatus.ENDED_WITH_MESSAGE);
                ConversionLogger.getLogger().log(Level.INFO, String.format("Unable to copy '%s'", sourcePath.getFileName()), e);
            }
            finally {
                if (fileMonitor != null) {
                    fileMonitor.stop();
                }
            }
        }
        return this.getStatus();
    }

    @Override
    public String getTitle() {
        return "Copy files...";
    }

    @Override
    public String getID() {
        return this.entry.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Progressable.ProgressStatus copyFiles(List<String> sourceFiles, Path targetFilePath) {
        if (sourceFiles == null) {
            return Progressable.ProgressStatus.ENDED_SUCCESS;
        }
        List<Path> sourcePaths = sourceFiles.stream().map(x$0 -> this.fileSystem.getPath((String)x$0, new String[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        if (sourceFiles.isEmpty()) {
            return Progressable.ProgressStatus.ENDED_SUCCESS;
        }
        this.setProgressMax(this.filesSize(sourcePaths));
        FileMonitor fileMonitor = new FileMonitor(targetFilePath, this.entry.getID(), x$0 -> this.fireProgressEvent(x$0));
        new Thread(fileMonitor).start();
        ConversionLogger.getLogger().info("START copy " + this.entry.getID());
        try (FileWriter fw = new FileWriter(targetFilePath.toFile(), true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter writer = new PrintWriter(bw);){
            for (Path sourcePath : sourcePaths) {
                byte[] sourceBytes = Files.readAllBytes(sourcePath);
                writer.write(new String(sourceBytes, StandardCharsets.UTF_8));
                writer.println();
            }
        }
        catch (IOException ex) {
            ConversionLogger.getLogger().log(Level.INFO, "ERROR copy " + this.entry.getID(), ex);
            Progressable.ProgressStatus progressStatus = Progressable.ProgressStatus.ENDED_FAILURE;
            return progressStatus;
        }
        finally {
            fileMonitor.stop();
        }
        ConversionLogger.getLogger().info("END copy " + this.entry.getID());
        return Progressable.ProgressStatus.ENDED_SUCCESS;
    }

    private long filesSize(List<Path> sourceFiles) {
        return sourceFiles.stream().mapToLong(this::fileSize).sum();
    }

    private long fileSize(Path filePath) {
        try {
            return Files.size(filePath);
        }
        catch (IOException ex) {
            return 0L;
        }
    }
}

