/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportDetails;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImporterType;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImportEntryList
implements Iterable<ImportEntry> {
    public static final String rootNodeName = "ImportEntries";
    private ImportDetails importDetails;
    private ImporterType type;
    private ArrayList<ImportEntry> entries = new ArrayList();
    private Document entriesDocument;
    private String defaultsLocation;

    public ImportEntryList(ImporterType type, Document entriesDocument, String defaultsLocation, ImportDetails importDetails) {
        this.entriesDocument = entriesDocument;
        this.defaultsLocation = defaultsLocation;
        this.type = type;
        this.importDetails = importDetails;
    }

    public ImporterType getType() {
        return this.type;
    }

    public ImportDetails getImportDetails() {
        return this.importDetails;
    }

    public void writeToUserFile() {
        this.updateXMLElement();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.entriesDocument);
            StreamResult result = new StreamResult(new File(this.defaultsLocation));
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            ConversionLogger.getLogger().info("Unable to update user data to file: " + e.getMessage());
        }
    }

    public void updateXMLElement() {
        NamedNodeMap attributes = this.entriesDocument.getElementsByTagName(rootNodeName).item(0).getAttributes();
        if (attributes != null) {
            for (String key : ImportDetails.importDetailsKeys) {
                Node keyNode;
                String value = this.getImportDetails().getProperty(key);
                if (value == null || value.isEmpty() || (keyNode = attributes.getNamedItem(key)) == null) continue;
                keyNode.setNodeValue(value);
            }
        }
        for (ImportEntry entry : this) {
            entry.updateXMLElement();
        }
    }

    public String toString() {
        String xmlString = "";
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(this.entriesDocument);
            transformer.transform(source, result);
            xmlString = result.getWriter().toString();
        }
        catch (IllegalArgumentException | TransformerException | TransformerFactoryConfigurationError e) {
            ConversionLogger.getLogger().info(String.format("Unable to convert user data entries element to String: %s", e.getMessage()));
        }
        return xmlString;
    }

    @Override
    public Iterator<ImportEntry> iterator() {
        return this.entries.iterator();
    }

    public ImportEntry first() {
        return this.entries.get(0);
    }

    public void add(ImportEntry newEntry) {
        this.entries.add(newEntry);
    }

    public int size() {
        return this.entries.size();
    }

    public void sort() {
        if (this.isComparableList(this.entries)) {
            ArrayList<ImportEntry> comparableList = this.entries;
            Collections.sort(comparableList);
        }
    }

    private boolean isComparableList(ArrayList<ImportEntry> list) {
        for (ImportEntry importEntry : list) {
            if (importEntry instanceof Comparable) continue;
            return false;
        }
        return true;
    }
}

