/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JsonUtils;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapterFactory;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.BaseWhenAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.ConfirmationCalendarAttributeGetter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.ConfirmationCalendarsAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.RuleBasedCalendarsAdapter;
import com.bmc.ctmconvert.generated.json.models.base.WhenScheduling;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

public class WhenSchedulingAdapter
extends BaseWhenAdapter {
    private final SchedEntity schedEntity;
    private final WhenScheduling whenSch;
    private final String rbcRelationship;

    public WhenSchedulingAdapter(SchedEntity schedEntity) {
        this.schedEntity = schedEntity;
        this.whenSch = new WhenScheduling();
        this.rbcRelationship = this.schedEntity.getAttr("TAG_RELATIONSHIP");
    }

    public WhenScheduling getWhenScheduling() {
        this.handleRuleBaseCalendars();
        this.handleTimeSettings();
        if (JsonUtils.isFolder(this.schedEntity)) {
            this.handleFolder();
        } else if (this.rbcRelationship != null && this.rbcRelationship.equals("A")) {
            this.handleJob();
        }
        return this.getWhenSch();
    }

    private WhenScheduling getWhenSch() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            if (this.isEmptyWhenScheduling(objectMapper)) {
                return null;
            }
        }
        catch (JsonProcessingException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
        }
        return this.whenSch;
    }

    private boolean isEmptyWhenScheduling(ObjectMapper objectMapper) throws JsonProcessingException {
        return "{}".equals(objectMapper.writeValueAsString((Object)this.whenSch));
    }

    private void handleFolder() {
        this.whenSch.withMonthDays(null);
        this.whenSch.withWeekDays(null);
        this.whenSch.withDaysRelation(null);
    }

    private void handleJob() {
        this.handleMonths();
        this.handleWeeks();
        this.handleDaysRelation();
        this.handleJobActivityPeriod();
        this.handleConfirmationCalendars();
    }

    private void handleJobActivityPeriod() {
        if (JsonUtils.isJob(this.schedEntity)) {
            this.setStartDate(this.whenSch, this.schedEntity.getAttr("ACTIVE_FROM"));
            this.setEndDate(this.whenSch, this.schedEntity.getAttr("ACTIVE_TILL"));
        }
    }

    private void handleDaysRelation() {
        String daysAndOr = Optional.ofNullable(this.schedEntity.getAttr("DAYS_AND_OR")).orElse("OR");
        this.whenSch.withDaysRelation(daysAndOr.equals("AND") ? WhenScheduling.DaysRelation.AND : WhenScheduling.DaysRelation.OR);
    }

    private void handleWeeks() {
        Optional<List<String>> weekDays = this.getWeekDays(this.schedEntity.getAttr("WEEKDAYS"));
        weekDays.ifPresent(this.whenSch::withWeekDays);
        this.setWeekDaysCalendar(this.whenSch, this.schedEntity.getAttr("WEEKSCAL"));
    }

    private void handleMonths() {
        String monthDays = Optional.ofNullable(this.schedEntity.getAttr("DAYS")).orElse("NONE");
        this.whenSch.withMonthDays(Arrays.asList(monthDays.split(",")));
        this.setMonths(this.whenSch, this.schedEntity::getAttr);
        this.setMonthDaysCalendar(this.whenSch, this.schedEntity.getAttr("DAYSCAL"));
    }

    private void handleConfirmationCalendars() {
        ConfirmationCalendarAttributeGetter.ConfirmationCalendarAttributes attributesFromEntity = ConfirmationCalendarAttributeGetter.getAttributesFrom(this.schedEntity);
        Optional<Object> confirmationCalendars = GlobalFunctions.isSmartFolder(this.schedEntity) ? Optional.empty() : new ConfirmationCalendarsAdapter(attributesFromEntity).getConfirmationCalendars();
        this.whenSch.withConfirmationCalendars(confirmationCalendars.orElse(null));
    }

    private void handleRuleBaseCalendars() {
        List<Properties> calendars = Optional.ofNullable(this.schedEntity.getTags()).orElse(Collections.emptyList());
        RuleBasedCalendarsAdapter ruleBasedCalendarsAdapter = new SchedEntityAdapterFactory().createRuleBasedCalendarsAdapter(calendars, this.schedEntity.type(), this.rbcRelationship);
        this.whenSch.withRuleBasedCalendars(ruleBasedCalendarsAdapter.getRuleBaseCalendars());
    }

    private void handleTimeSettings() {
        String timeFrom = Optional.ofNullable(this.schedEntity.getAttr("TIMEFROM")).orElse(null);
        String timeTo = Optional.ofNullable(this.schedEntity.getAttr("TIMETO")).orElse(null);
        String fromDays = Optional.ofNullable(this.schedEntity.getAttr("FROM_DAYSOFFSET")).orElse(null);
        String toDays = Optional.ofNullable(this.schedEntity.getAttr("TO_DAYSOFFSET")).orElse(null);
        this.whenSch.withFromTime(timeFrom).withToTime(timeTo).withFromDays(fromDays).withToDays(toDays);
    }
}

