/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.actions;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.actions.DestinationFactory;
import com.bmc.ctmconvert.generated.json.models.base.JobProperties;
import com.bmc.ctmconvert.generated.json.models.notifications.Notify;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class AlertsAdapter {
    private final SchedEntity schedEntity;

    public AlertsAdapter(SchedEntity schedEntity) {
        this.schedEntity = schedEntity;
    }

    public void setNotification(JobProperties jobProperties) {
        String notifyPrefix = "Notify_";
        AtomicInteger counter = new AtomicInteger(1);
        if (this.schedEntity.getShouts() != null) {
            for (Properties alert : this.schedEntity.getShouts()) {
                this.getNotify(alert).ifPresent(notif -> jobProperties.withAdditionalProperty(notifyPrefix + counter.getAndIncrement(), notif));
            }
        }
    }

    private Optional<Notify> getNotify(Properties alert) {
        return switch (alert.getProperty("WHEN")) {
            case "OK" -> Optional.of(this.getNotifyOK(alert));
            case "NOTOK" -> Optional.of(this.getNotifyNotOK(alert));
            case "RERUN" -> Optional.of(this.getNotifyRerun(alert));
            case "EXECTIME" -> Optional.of(this.getNotifyExecutionTime(alert));
            case "LATETIME" -> Optional.of(this.getNotifyDoesNotEnd(alert));
            case "LATESUB" -> Optional.of(this.getNotifyDoesNotStart(alert));
            default -> Optional.empty();
        };
    }

    private Notify getNotifyRerun(Properties alert) {
        Notify notify = new Notify();
        notify.setType(Notify.Type.NOTIFY_RE_RUN);
        this.handleCommonNotifyParameters(alert, notify);
        return notify;
    }

    private Notify getNotifyDoesNotEnd(Properties alert) {
        Notify notify = new Notify();
        notify.setType(Notify.Type.NOTIFY_DOES_NOT_END);
        this.handleCommonNotifyParameters(alert, notify);
        notify.setBy(alert.getProperty("TIME"));
        return notify;
    }

    private Notify getNotifyExecutionTime(Properties alert) {
        Notify notify = new Notify();
        String regex = "([<>+-]{1})(\\d+)";
        Pattern pattern = Pattern.compile(regex, 8);
        notify.setType(Notify.Type.NOTIFY_EXECUTION_TIME);
        this.handleCommonNotifyParameters(alert, notify);
        String time = alert.getProperty("TIME");
        Matcher matcher = pattern.matcher(time);
        if (matcher.find()) {
            String sign = matcher.group(1);
            String timeNum = matcher.group(2);
            notify.setCriteria(this.getCriteria(sign));
            notify.setValue(timeNum);
        }
        return notify;
    }

    private Notify.Criteria getCriteria(String sign) {
        return switch (sign) {
            case "<" -> Notify.Criteria.LESS_THAN;
            case "+" -> Notify.Criteria.GREATER_THAN_AVERAGE;
            case "-" -> Notify.Criteria.LESS_THAN_AVERAGE;
            default -> Notify.Criteria.GREATER_THAN;
        };
    }

    private Notify getNotifyDoesNotStart(Properties alert) {
        Notify notify = new Notify();
        String time = alert.getProperty("TIME");
        time = this.setTypeAndTime(notify, time);
        this.handleCommonNotifyParameters(alert, notify);
        notify.setBy(time);
        return notify;
    }

    @NotNull
    private String setTypeAndTime(Notify notify, String time) {
        if (time.startsWith("#")) {
            notify.setType(Notify.Type.NOTIFY_LATE_CYCLIC_SUBMIT);
            return AlertsAdapter.removeLateCyclicSubmitTimePrefixFrom(time);
        }
        notify.setType(Notify.Type.NOTIFY_DOES_NOT_START);
        return time;
    }

    @NotNull
    private static String removeLateCyclicSubmitTimePrefixFrom(String timeWithLateCyclicTimePrefix) {
        return timeWithLateCyclicTimePrefix.replaceFirst("#", "");
    }

    private Notify getNotifyNotOK(Properties alert) {
        Notify notify = new Notify();
        notify.setType(Notify.Type.NOTIFY_NOT_OK);
        this.handleCommonNotifyParameters(alert, notify);
        return notify;
    }

    private Notify getNotifyOK(Properties alert) {
        Notify notify = new Notify();
        notify.setType(Notify.Type.NOTIFY_OK);
        this.handleCommonNotifyParameters(alert, notify);
        return notify;
    }

    private void handleCommonNotifyParameters(Properties alert, Notify notify) {
        notify.setMessage(alert.getProperty("MESSAGE"));
        notify.setDestination(DestinationFactory.getDestination(this.schedEntity, alert));
        notify.setUrgency(this.getUrgency(alert.getProperty("URGENCY")));
        Optional.ofNullable(alert.getProperty("DAYSOFFSET")).ifPresent(notify::setDays);
    }

    private Notify.Urgency getUrgency(String urgency) {
        return switch (urgency) {
            case "U" -> Notify.Urgency.URGENT;
            case "V" -> Notify.Urgency.VERY_URGENT;
            default -> Notify.Urgency.REGULAR;
        };
    }
}

