/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.DetectSpawnedJobAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.DetectSpawnedJob;
import com.bmc.ctmconvert.generated.json.models.job_types.SapBWProcessChain;
import java.util.Optional;
import java.util.Set;

public class SapBWProcessChainAdapter
extends BaseJobAdapter<SapBWProcessChain.Type> {
    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.variablesAdapter.getUsedVariablesFromStr(this.getDetectSpawnedJob().toString());
        return usedVariablesFromStr;
    }

    public SapBWProcessChainAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    protected BaseJob buildBaseJob() {
        SapBWProcessChain sapBWProcessChain = new SapBWProcessChain().withConnectionProfile(this.schedEntity.getVariable("%%SAPR3-ACCOUNT")).withRetrieveLog(this.getRetrieveLog()).withDetectSpawnedJob(this.getDetectSpawnedJob());
        this.getProcessChainDescription().ifPresent(sapBWProcessChain::setProcessChainDescription);
        this.getId().ifPresent(sapBWProcessChain::setId);
        this.getRerunOption().ifPresent(sapBWProcessChain::setRerunOption);
        this.getEnablePeriodicJob().ifPresent(sapBWProcessChain::setEnablePeridoicJob);
        this.getConsiderOnlyOverallChainStatus().ifPresent(sapBWProcessChain::setConsiderOnlyOverallChainStatus);
        return sapBWProcessChain;
    }

    private DetectSpawnedJob getDetectSpawnedJob() {
        return new DetectSpawnedJobAdapter(this.getVariablesAdapter(), this.schedEntity.getJobName()).getDetectSpawnedJob();
    }

    private String getRetrieveLog() {
        boolean retrieveLog = this.getVariablesAdapter().getVariableByName("%%SAPR3-JOBLOG").map("*SYSOUT"::equals).orElse(false);
        return String.valueOf(retrieveLog);
    }

    private Optional<Boolean> getConsiderOnlyOverallChainStatus() {
        return this.variableToPeriodicBoolean("%%SAPR3-PC_DONT_POLL");
    }

    private Optional<Boolean> variableToPeriodicBoolean(String variable) {
        String considerOnlyOverall = this.getVariablesAdapter().getVariableByName(variable).orElse("");
        if ("X".equals(considerOnlyOverall)) {
            return Optional.of(true);
        }
        if ("N".equals(considerOnlyOverall)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private Optional<Boolean> getEnablePeriodicJob() {
        return this.variableToPeriodicBoolean("%%SAPR3-PC_periodic");
    }

    private Optional<SapBWProcessChain.RerunOption> getRerunOption() {
        String rerunOption = this.getVariablesAdapter().getVariableByName("%%SAPR3-PROCESSCHAIN_RERUN_INSTANCE").orElse("");
        if ("PC_RUN_CURR_INSTANCE".equals(rerunOption)) {
            return Optional.of(SapBWProcessChain.RerunOption.RESTART_FROM_FAILIURE_POINT);
        }
        if ("PC_RUN_NEW_INSTANCE".equals(rerunOption)) {
            return Optional.of(SapBWProcessChain.RerunOption.RERUN_FROM_START);
        }
        return Optional.empty();
    }

    private Optional<String> getId() {
        return this.getVariablesAdapter().getVariableByName("%%SAPR3-ProcessChain_ID");
    }

    private Optional<String> getProcessChainDescription() {
        return this.getVariablesAdapter().getVariableByName("%%SAPR3-ProcessChain_Desc");
    }

    @Override
    public SapBWProcessChain.Type getType() {
        return SapBWProcessChain.Type.JOB_SAP_BW_PROCESS_CHAIN;
    }
}

