/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JsonUtils;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.OS400CommandAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.OS400MultiCommandAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.OS400ProgramJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.OS400ScriptJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.base.OS400BaseJob;
import com.bmc.ctmconvert.generated.json.models.base.Variable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class OS400BaseJobAdapter<T>
extends BaseJobAdapter<T> {
    private static final List<String> OS_400_VARIABLES_THAT_REMAIN_IN_JSON = Stream.of("%%OS400-JOB_NAME", "%%OS400-JOB_OWNER", "%%OS400-OVER_LIB", "%%OS400-CTMRSTRCTD_ACTION", "%%OS400-OVER_LIB", "%%OS400-AEV_LEN", "%%OS400-SCRIPT_FILE_IGNERR", "%%OS400-SCRIPT_FILE_LOGINFMSG", "%%OS400-SCRIPT_FILE_DLTF").map(GlobalFunctions::removeVariablePrefix).toList();

    public static OS400BaseJobAdapter<?> createJobAdapter(SchedEntity entity, SchedEntity parent) {
        return OS400BaseJobAdapter.getOs400BaseJobAdapter(entity, parent);
    }

    private static String getObjType(SchedEntity entity) {
        return entity.getVariable("%%OS400-OBJTYP");
    }

    @NotNull
    private static OS400BaseJobAdapter<?> getOs400BaseJobAdapter(SchedEntity entity, SchedEntity parent) {
        return switch (OS400BaseJobAdapter.getObjType(entity)) {
            case "*PGM" -> new OS400ProgramJobAdapter(entity, parent);
            case "*FILE" -> new OS400ScriptJobAdapter(entity, parent);
            case "*CMDLINE" -> new OS400CommandAdapter(entity, parent);
            case "*MULTICMD" -> new OS400MultiCommandAdapter(entity, parent);
            default -> throw new RuntimeException("Unknown OS400 Job Type: " + OS400BaseJobAdapter.getObjType(entity));
        };
    }

    private static boolean isOs400Type(SchedEntity entity) {
        return switch (OS400BaseJobAdapter.getObjType(entity)) {
            case "*PGM", "*CMDLINE", "*FILE", "*MULTICMD" -> true;
            default -> false;
        };
    }

    @Override
    protected final BaseJob buildBaseJob() {
        OS400BaseJob os400BaseJob = this.buildBaseOs400Job();
        List<Variable> variablesToKeep = Optional.ofNullable(os400BaseJob.getVariables()).orElse(Collections.emptyList());
        return ((OS400BaseJob)os400BaseJob.withVariables((List)this.getOs400Variables(variablesToKeep))).withSpecialEnvironment(this.getSpecialEnvironment());
    }

    protected abstract OS400BaseJob buildBaseOs400Job();

    public OS400BaseJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    protected List<Variable> getOs400Variables(List<Variable> variablesToKeep) {
        Stream<Variable> variables = this.getVariablesAdapter().getCMVariables().stream().map(VariableWrapper::new).filter(variable -> OS_400_VARIABLES_THAT_REMAIN_IN_JSON.stream().anyMatch(v -> variable.getKey().startsWith((String)v))).map(variable -> {
            String keyWithoutPrefix = GlobalFunctions.removeVariablePrefix(variable.getKey());
            return new Variable().withAdditionalProperty(keyWithoutPrefix, variable.getValue());
        });
        List<Variable> allVariables = Stream.concat(variables, variablesToKeep.stream()).toList();
        return JsonUtils.getOrNull(allVariables);
    }

    public static boolean isOs400Job(SchedEntity entity) {
        return "OS400".equals(entity.getAttr("APPL_TYPE")) && OS400BaseJobAdapter.isOs400Type(entity);
    }

    private OS400BaseJob.SpecialEnvironment getSpecialEnvironment() {
        Optional<String> env = Optional.ofNullable(this.schedEntity.getVariable("%%OS400-SPCENV"));
        return env.map(e -> switch (e) {
            case "QSH" -> OS400BaseJob.SpecialEnvironment.Q_SHELL;
            case "S38" -> OS400BaseJob.SpecialEnvironment.S_38;
            default -> null;
        }).orElse(null);
    }
}

